
typedef struct Callback_struct Callback;
typedef struct CallbackData_struct CallbackData;
typedef void (*CallbackFunc)(CallbackData *);

struct CallbackData_struct {
	Callback *self;
	Conn *conn;
	YwPacket *pkt;
	YwPacket *ret;
	const char *err;
	int reply_sent;
};

/*
 * flags is one of yw_*_word for single argument calls,
 * yw_bad_word (i.e. 0), when it's not single argument,
 * possibly ored together with ARG_TAGS - call takes tags
 * as arguments, and HAS_RETURN - when it has real return value
 * and cannot be asked in void mode.
 */
#define ARG_TAGS	0x0100
#define HAS_RETURN	0x0200

struct Callback_struct {
	struct Callback_struct *next;
	const char *call_name;
	void *userdata;
	int flags;
	CallbackFunc func;
};


void install_callback(const char *name, int flags, CallbackFunc func, 
		      void *userdata);
void run_callback(Conn *conn, YwPacket *pkt);

