/* $Id: callback.c,v 1.6 2001/05/04 11:04:28 malekith Exp $ */

#include "serv.h"
#include <yw/hash.h>

/* protects {{{ */
static YwLock callbacks_lock = YW_LOCK_INIT;
static YwHash *callbacks;
/* }}} */

void install_callback(const char *name, int flags, CallbackFunc func, 
		      void *userdata)
{
	Callback *cb;
	
	yw_lock_rw(&callbacks_lock);
	if (callbacks == NULL)
		callbacks = yw_hash_new();
	cb = yw_hash_find(callbacks, name);
	yw_assert(cb == NULL);
	cb = YW_NEW(Callback);
	cb->call_name = yw_strdup(name);
	cb->flags = flags;
	cb->userdata = userdata;
	cb->func = func;
	yw_hash_add(callbacks, cb);
	yw_unlock_rw(&callbacks_lock);
}

static const char *type_check(CallbackData *cd)
{
	YwWord *w;
	YwWordType t; 
	
	if ((cd->self->flags & HAS_RETURN) != 0
	    && yw_packet_type(cd->pkt) != yw_call_packet) 
		return "call asked in void mode";
		
	w = yw_packet_word(cd->pkt, 1);
	if (cd->self->flags & ARG_TAGS) {
		if (yw_tag_validate(w))
			return "syntax error in taglist";
	} else {
		switch (t = (YwWordType)(cd->self->flags & 0xff)) {
		case yw_bad_word:
			break;	/* no checking */

		case yw_void_word:
			if (w && 
			    (yw_word_fetch_void(w) == -1 || yw_word_next(w)))
				return "no argument expected";
			break;
		case yw_string_word:
		case yw_key_word:
		case yw_int_word:
		case yw_bindata_word:
			if (w == NULL || yw_word_type(w) != t || 
			    yw_word_next(w))
				return "single argument of "
					"certain type expected";
			break;
		case yw_ptr_word:
		default:
			yw_halt();
		}
	}
	
	return NULL;
}

void run_callback(Conn *conn, YwPacket *pkt)
{
	CallbackData cd;
	const char *cmd = NULL;
	YwWord *w;
	
	cd.err = NULL;
	
	w = yw_packet_word(pkt, 0);
	if (yw_word_fetch_keyword(w, &cmd)) {
		cd.err = "badly formed command";
		goto croak;
	}
	
	cd.ret = NULL;
	cd.conn = conn;
	cd.pkt = pkt;
	cd.reply_sent = 0;
	
	yw_lock_ro(&callbacks_lock);
	cd.self = yw_hash_find(callbacks, cmd);
	yw_unlock_ro(&callbacks_lock);

	if (cd.self == NULL) {
		cd.err = "unknown command";
		goto croak;
	}

	if ((cd.err = type_check(&cd)))
		goto croak;
		
	if (yw_packet_type(pkt) == yw_call_packet)
		cd.ret = yw_packet_new(yw_reply_packet);
	else
		cd.ret = NULL;
		
	cd.self->func(&cd);

			
croak:
	if (cd.err)
		printk(YL_INFO "callback error: client=%d, cmd='%s': %s",
			conn->cid, cmd, cd.err);
			
	if (yw_packet_type(pkt) != yw_call_packet || cd.reply_sent) {
		yw_packet_free(cd.ret);
		return;
	}
	
	if (cd.ret == NULL || yw_packet_length(cd.ret) == 0) {
		if (cd.err)
			yw_conn_send_and_free(conn->conn, 
				yw_packet_make(yw_reply_packet, 
					"k", "error",
					"d", cd.err,
					YW_END));
		else
			yw_conn_send_and_free(conn->conn, 
				yw_packet_make(yw_reply_packet, 
					"k", "ok",
					YW_END));
	} else
		yw_conn_send(conn->conn, cd.ret);
		
	yw_packet_free(cd.ret);
}
