/* $Id: base.c,v 1.6 2001/05/23 08:46:01 malekith Exp $ */

#include "serv.h"
#include <yw/map.h>

static void ping(CallbackData *cd)
{
	yw_packet_append_keyword(cd->ret, "pong");
	yw_packet_append_words(cd->ret, yw_packet_word(cd->pkt, 1), -1);
}

static void dmesg(CallbackData *cd)
{
	char *buf;
	int s = 4000;
	YwString str;
	
	yw_word_fetch_int(yw_packet_word(cd->pkt, 1), &s);
	if (s < 100)
		s = 100;
	else if (s > 16000)
		s = 16000;
	buf = yw_malloc_0(s + 1);
	s = read_log_buf(buf, s);

	yw_packet_append_keyword(cd->ret, "dmesg");
	yw_string_assign_cstring(&str, NULL, buf, -1);
	yw_packet_append_string(cd->ret, &str);
	yw_string_free(&str);
}

void init_display(Conn *);
void init_wm(Conn *);

static void get_cid(CallbackData *cd)
{
	yw_packet_append_keyword(cd->ret, "cid");
	yw_packet_append_int(cd->ret, cd->conn->cid);
}

static void i_am(CallbackData *cd)
{
	const char *t, *tn = NULL;
	YwMapEntry e[] = {
		{ "display", display },
		{ "window_manager", window_manager },
		{ NULL, normal_client }
	};

	yw_word_fetch_keyword(yw_packet_word(cd->pkt, 1), &t);
	
	switch (yw_map(t, e, NULL)) {
	case display:
		tn = "display";
		init_display(cd->conn);
		break;
	case normal_client:
		cd->conn->type = normal_client;
		tn = "normal_client";
		break;
	case window_manager:
		tn = "window_manager";
		init_wm(cd->conn);
		break;
	}

	printk(YL_INFO "client %d cliams to be %s -> %s",
		cd->conn->cid, t, tn);
}

void install_base_callbacks()
{
	install_callback("ping", HAS_RETURN , ping, NULL);
	install_callback("dmesg", HAS_RETURN | yw_int_word, dmesg, NULL);
	install_callback("i_am", yw_key_word, i_am, NULL);
	install_callback("get_cid", yw_key_word, get_cid, NULL);
}
