/* $Id: approx.c,v 1.3 2001/05/04 11:04:28 malekith Exp $ */

#include "serv.h"

void precache_widths(const YwString *str);
int char_width(int ch);

extern uint16_t *yw_fallback_table[256];

static uint16_t *find_fallback(int ch)
{
	uint16_t *tab, *start;
	static uint16_t def_fallback[] = { 1, '?' };
	int n, off = -1, i;

	tab = yw_fallback_table[(ch ^ (ch >> 8)) & 0xff];
	
	start = tab + tab[0];
	n = *tab++ / 2;
	while (n--) {
		if (*tab++ == ch) {
			off = *tab;
			break;
		}
		tab++;
	}
	if (off == -1)
		return def_fallback;
		
	for (tab = start + off; *tab; tab += *tab) {
		for (i = 0; i < *tab; i++)
			if (char_width(tab[i]) < 0)
				break;
		if (i == *tab)
			break;
	}

	return *tab == 0 ? def_fallback : tab;
}

void approx(YwString *str)
{
	int i, nn;
	int n = 0, k = 0, p = 0, x = 0;
	uint16_t *f;
	uint32_t *s;
	
	precache_widths(str);
	
	for (i = 0; i < str->len; i++)
		if (char_width(str->chars[i]) == -1) {
			f = find_fallback(str->chars[i]);
			n += *f;
		} else if (char_width(str->chars[i]) == -2)
			return;		/* display is not connected */

	if (n == 0)
		return;		/* nothing to do... */
	
	s = yw_malloc((n + str->len) * sizeof(uint32_t));
	
	for (i = 0; i < str->len; i++) {
		if (char_width(str->chars[i]) == -1) {
			f = find_fallback(str->chars[i]);
			k += *f;
			if (k > n) {
				/* oops, display changed? */
				yw_free(s);
				approx(str);
				return;
			}
			nn = *f++;
			while (nn--)
				s[p++] = *f++;
		} else { 
			s[p++] = str->chars[i];
			x++;
		}
	}

	k += x;
	yw_string_free(str);
	yw_string_assign_utf32(str, s, k);
	yw_free(s);
}
