#include <ytk/ytk.h>
#include <yw/util.h>

void ytk_draw(YtkObject *o)
{
	ytk_send_void_msg_va(o, "k", "draw", YW_END);
}

YwWord *ytk_get_op(YtkObject *o, const char *name)
{
	YwPacket *ret;
	const char *kw;
	YwWord *w = NULL;

	ret = ytk_send_msg_va(o, "k" "get_op", name, YW_END);

	if (yw_word_fetch_keyword(yw_packet_word(ret, 0), &kw) == 0 &&
	    strcmp(kw, "op_value") == 0 &&
	    (w = yw_packet_word(ret, 1)) != NULL)
	   	w = yw_word_copy_of(w);
	yw_packet_free(ret);

	return w;
}

int ytk_set_op(YtkObject *o, const char *name, const YwWord *val)
{
	YwPacket *msg = yw_packet_make(yw_call_packet, 
			"k" "set_op", name,
			YW_END);
	YwPacket *ret;
	const char *kw;
	int r = 0;
	
	yw_packet_append_word(msg, val);

	ret = ytk_send_msg(o, msg);

	if (yw_word_fetch_keyword(yw_packet_word(ret, 0), &kw) ||
	    strcmp(kw, "ok") != 0)
	    	r = -1;
		
	yw_packet_free(msg);
	yw_packet_free(ret);

	return r;
}

/* Target is first yw_string_free()ed|yw_free()ed, and then assigned
 * value of given op. 0 if successful, -1 otherwise. */

int ytk_get_string_op(YtkObject *o, const char *name, YwString *target)
{
	YwWord *w;
	YwString *tmp;
	int r = -1;

	if ((w = ytk_get_op(o, name)) != NULL &&
	    yw_word_fetch_string(w, &tmp) == 0) {
		yw_string_free(target);
	    	yw_string_assign_string(target, tmp);
		r = 0;
	}
	
	yw_word_free(w);
	
	return r;
}

int ytk_get_keyword_op(YtkObject *o, const char *name, char **target)
{
	YwWord *w;
	const char *tmp;
	int r = -1;

	if ((w = ytk_get_op(o, name)) != NULL &&
	    yw_word_fetch_keyword(w, &tmp) == 0) {
		yw_setstr(target, tmp);
		r = 0;
	}

	yw_word_free(w);
	
	return r;
}
