/* $Id: responder.c,v 1.2 2001/06/02 11:18:29 malekith Exp $ */

/* standrd YTK responder object, C shorthand */

#include <ytk/ytk.h>
#include <yw/util.h>

struct resp_data {
	void *user_data;
	YtkResponder resp;
	YtkObject *self;
};

static YwPacket *resp_callback(void *data, YwPacket *pkt)
{
	struct resp_data *d;
	const char *kw;
	YwWord *arg;
	

	if (yw_word_fetch_keyword(yw_packet_word(pkt, 0), &kw) ||
	    strcmp(kw, "event") != 0 ||
	    yw_word_fetch_keyword(yw_packet_word(pkt, 1), &kw) ||
	    (arg = yw_packet_word(pkt, 2)) == NULL)
	    	return yw_packet_make(yw_reply_packet,
					"g" "error", "msg not understood",
					YW_END);
	
	d = data;
	if (d->resp(d->user_data, kw, arg))
		ytk_object_send_event_up(d->self, pkt);

	return NULL;
}

static void resp_finalizer(void *data)
{
	yw_free(data);
}

YtkObject *ytk_responder(void *data, YtkResponder resp_fnc)
{
	struct resp_data *d;

	d = YW_NEW_0(struct resp_data);
	d->user_data = data;
	d->resp = resp_fnc;
	d->self = ytk_new_object(NULL, resp_callback, resp_finalizer, d);

	return d->self;
}
