/* $Id: message.c,v 1.2 2001/05/21 09:58:52 malekith Exp $ */

#include <ytk/ytk.h>
#include <ytk/int/object.h>

YwPacket *ytk_send_msg(YtkObject *obj, YwPacket *msg)
{
	YwPacket *pkt = NULL;

	if (obj->callback)
		pkt = obj->callback(obj->data, msg);

	if (pkt && yw_packet_type(msg) != yw_call_packet) {
		yw_packet_free(pkt);
		pkt = NULL;
	}

	return pkt;
}

YwPacket *ytk_send_msg_ap(YtkObject *obj, va_list ap)
{
	YwPacket *o;
	YwPacket *msg;
	
	msg = yw_packet_make_v(yw_call_packet, ap);
	
	o = ytk_send_msg(obj, msg);

	yw_packet_free(msg);

	return o;
}

YwPacket *ytk_send_msg_va(YtkObject *obj, ...)
{
	YwPacket *o;
	va_list ap;

	va_start(ap, obj);
	o = ytk_send_msg_ap(obj, ap);
	va_end(ap);

	return o;
}

void ytk_send_void_msg_ap(YtkObject *obj, va_list ap)
{
	YwPacket *msg;
	
	msg = yw_packet_make_v(yw_void_call_packet, ap);
	
	ytk_send_msg(obj, msg);

	yw_packet_free(msg);
}

void ytk_send_void_msg_va(YtkObject *obj, ...)
{
	va_list ap;

	va_start(ap, obj);
	ytk_send_void_msg_ap(obj, ap);
	va_end(ap);
}
