/* $Id: focus.c,v 1.3 2001/06/02 11:18:29 malekith Exp $ */

#include <ytk/ytk.h>
#include <ytk/int/object.h>
#include <yw/util.h>

#include <string.h>

int ytk_object_focusable(YtkObject *o)
{
	YwPacket *pkt;
	int r;
	const char *kw;

	pkt = ytk_send_msg_va(o, "k", "can_get_focus", YW_END);

	r = (pkt && 
	     yw_word_fetch_keyword(yw_packet_word(pkt, 1), &kw) == 0 && 
	     strcmp(kw, "yes") == 0);
	     
	yw_packet_free(pkt);
	
	return r;
}

int ytk_object_focus(YtkObject *o, YtkObject *f)
{
	YtkObject *p;

	for (p = o->children; p; p = p->next)
		if (p == f)
			break;
	if (p != f) {
		ytk_fatal("ytk_object_focus: requested focus of non-child");
		return -1;
	}

	if (!ytk_object_focusable(f))
		return -1;
		
	o->active = f;
	
	return 0;
}

int ytk_object_focus_next(YtkObject *o)
{
	YtkObject *beg, *p;
	int go_up = 0;
	
	if (o->children == NULL)
		return o->parent ? ytk_object_focus_next(o->parent) : -1;
		
	if (o->active && o->active->next)
		p = o->active->next;
	else {
		if (o->active)
			go_up++;
		p = o->children;
	}
		
	o->active = NULL;
	
	beg = p;

	do {
		if (ytk_object_focus(o, p) == 0) {
			if (go_up && o->parent)
				ytk_object_focus_next(o->parent);
			return 0;
		}
			
		if ((p = p->next) == NULL) {
			p = o->children;
			go_up++;
		}
	} while (p != beg);

	if (o->parent)
		return ytk_object_focus_next(o->parent);
		
	return -1;
}

static YtkObject *prev(YtkObject *o, YtkObject *f, int *go_up)
{
	YtkObject *p;

	if (f == o->children) {
		(*go_up)++;
		return o->last_child;
	}
		
	for (p = o->children; p; p = p->next)
		if (p->next == f)
			return p;
	
	yw_halt();
	return NULL;	/* dummy */
}

int ytk_object_focus_prev(YtkObject *o)
{
	YtkObject *beg, *p;
	int go_up = 0;
	
	if (o->children == NULL)
		return o->parent ? ytk_object_focus_prev(o->parent) : -1;
		
	if (o->active)
		p = prev(o, o->active, &go_up);
	else
		p = o->last_child;
		
	o->active = NULL;
	
	beg = p;

	do {
		if (ytk_object_focus(o, p) == 0) {
			if (go_up && o->parent)
				ytk_object_focus_prev(o->parent);
			return 0;
		}
		
		p = prev(o, p, &go_up);
	} while (p != beg);

	if (o->parent)
		return ytk_object_focus_prev(o->parent);

	return -1;
}
