/* $Id: context.c,v 1.2 2001/05/24 14:53:58 malekith Exp $ */

#include <ytk/ytk.h>
#include <ytk/int/object.h>
#include <ytk/int/context.h>
#include <yw/util.h>

#include <string.h>

void ytk_bind_to_context(YtkContext *ctx, YtkObject *o)
{
	int i, tmp;
	
	if (ctx == NULL)
		ctx = ytk_default_context();
	
	if (o->refcnt == 0) {
		if ((ctx = o->context) == NULL)
			return;
		
		for (i = 0; i < ctx->objs_cnt; i++)
			if (ctx->objs[i] == o) {
				ctx->objs[i] = NULL;
				o->context = NULL;
				return;
			}
			
		yw_halt();
	}

	tmp = o->refcnt;
	o->refcnt = 0;
	ytk_bind_to_context(NULL, o);
	o->refcnt = tmp;

	o->context = ctx;

	for (i = 0; i < ctx->objs_cnt; i++)
		if (ctx->objs[i] == NULL) {
			ctx->objs[i] = o;
			return;
		}
	if ((i = ctx->objs_cnt) == 0)
		ctx->objs_cnt = 16;
	else
		ctx->objs_cnt *= 2;
		
	ctx->objs = yw_realloc(ctx->objs, 
			       ctx->objs_cnt * sizeof(YtkObject*));
	ctx->objs[i++] = o;
	while (i < ctx->objs_cnt)
		ctx->objs[i++] = NULL;
}

YtkContext *ytk_new_context()
{
	YtkContext *ctx;

	ctx = YW_NEW_0(YtkContext);

	return ctx;
}


YtkContext *ytk_default_context()
{
	static YtkContext *ctx;

	if (ctx == NULL)
		ctx = ytk_new_context();
	
	return ctx;
}

void ytk_bind_connection_to_context(YtkContext *ctx, YwConnection *conn)
{
	if (ctx == NULL)
		ctx = ytk_default_context();
		
	if (conn)
		ctx->conn = conn;
}

static void process_kbd(YtkContext *ctx, YwPacket *pkt)
{
	YtkObject *o = NULL;
	YwPacket *ret;
	int i, win_id;
	const char *kw;
	
	if (yw_word_fetch_int(yw_packet_word(pkt, 1), &win_id))
		return;
		
	/* first look for appropiate window */
	for (i = 0; i < ctx->objs_cnt; i++)
		if ((o = ctx->objs[i]) && 
		    o->window &&
		    yw_window_id(o->window) == win_id)
		    	break;
		else
			o = NULL;
			
	if (o == NULL)
		return;
	
	/* walk down */
	while (o->active)
		o = o->active;

	yw_packet_set_type(pkt, yw_call_packet);

	/* and now, walk up, sending events, until it's handled */
	for (; o; o = o->parent) {
		ret = ytk_send_msg(o, pkt);
		if (yw_word_fetch_keyword(yw_packet_word(ret, 1), &kw) == 0 &&
		    strcmp(kw, "yes") == 0)
		    	break;
	}
}

YwPacket *ytk_process_events(YtkContext *ctx, int timeout)
{
	YwPacket *pkt;
	enum {
		x_kbd,
		x_unknown
	};
	static YwMapEntry e[] = {
		{ "kbd", x_kbd },
		{ NULL, x_unknown }
	};
	static YwMapCache *cache;
	int res;

	if (ctx == NULL)
		ctx = ytk_default_context();
	
	pkt = yw_conn_recv(ctx->conn, timeout);

	if (pkt == NULL)
		return NULL;
	
	if (yw_word_fetch_mapped_keyword(yw_packet_word(pkt, 0), 
				         e, &cache, &res) == 0 &&
	    res != x_unknown) {
	    	switch (res) {
		case x_kbd:
			process_kbd(ctx, pkt);
			break;
		}

		yw_packet_free(pkt);
		pkt = NULL;
	}

	if (pkt == NULL) {
		pkt = ctx->waiting_packet;
		ctx->waiting_packet = NULL;
	}
	
	return pkt;
}

void ytk_check_state(YtkContext *ctx)
{
	const char *file;
	int line;
	int state;
	
	if (ctx == NULL)
		ctx = ytk_default_context();
	
	yw_conn_get_state(ctx->conn, &file, &line, &state);
	
	if (state)
		ytk_fatal("YwConnection bailed out: "
			  "state = %s [%d], %s:%d\n", 
			  yw_strerror(state), 
			  state, file, line);
}

YwConnection *ytk_init()
{
	YwConnection *conn;

	conn = yw_conn_new();
	yw_conn_open(conn);

	ytk_bind_connection_to_context(NULL, conn);

	ytk_check_state(NULL);
	
	return conn;
}

void ytk_object_send_event_up(YtkObject *self, YwPacket *pkt)
{
	YtkObject *target;
	
	if ((target = self->responder) == NULL)
		if ((target = self->parent) == NULL) {
			YtkContext *ctx = self->context;
			if (ctx == NULL)
				ctx = ytk_default_context();
			yw_assert(ctx->waiting_packet == NULL);
			ctx->waiting_packet = yw_packet_copy_of(pkt);
			return;
		}
	
	pkt = ytk_send_msg(target, pkt);
	yw_packet_free(pkt);
}

void ytk_object_set_responder(YtkObject *o, YtkObject *r)
{
	if (o->responder)
		ytk_dec_ref(o->responder);
	if (r)
		ytk_inc_ref(r);
	o->responder = r;
}
