#include <ytk/ytk.h>
#include <yw/util.h>

#include <stdlib.h>
#include <stdio.h>

void ypp_init();

YwConnection *conn;

struct form {
	int fini;
	YwString name;
	YwString cpu;
	YtkObject *name_box, *cpu_box;
};

int update_resp(void *ff, const char *name, YwWord *arg)
{
	struct form *f = ff;

	(void)arg;
	
	if (strcmp(name, "ok") == 0) {
		ytk_get_string_op(f->name_box, "text", &f->name);
		ytk_get_string_op(f->cpu_box, "text", &f->cpu);
		f->fini++;
	} else if (strcmp(name, "cancel") == 0) {
		f->fini++;
	} else
		return -1;
	
	return 0;
}

void update(struct form *f)
{
	YtkObject *win;
	
	win = ytk_new_va("YppWindow",  
		"p" "connection", conn,
		"p" "responder", ytk_responder(f, update_resp),
		"g" "title", "Update One",
		"i" "width", 40,
		"i" "height", 7,
		"i" "spacing", 1,
		"k" "layout", "horizontal",
		"p" "child", ytk_new_va("YppGroup",
		    "k" "layout", "vertical",
		    "i" "spacing", 1,
		    "p" "child", ytk_new_va("YppLabel", 
			"d" "text", "Name",
		    YW_END),
		    "p" "child", ytk_new_va("YppLabel", 
			"d" "text", "CPU",
		    YW_END),
		    "p" "child", ytk_new_va("YppButton", 
		        "d" "text", "Ok",
			"k" "event", "ok",
		    YW_END),
		YW_END),
		"p" "child", ytk_new_va("YppGroup",
		    "k" "layout", "vertical",
		    "i" "spacing", 1,
		    "p" "child", f->name_box = ytk_new_va("YppInput", 
			"s" "text", &f->name,
		    YW_END),
		    "p" "child", f->cpu_box = ytk_new_va("YppInput", 
			"s" "text", &f->cpu,
		    YW_END),
		    "p" "child", ytk_new_va("YppButton", 
		        "d" "text", "Cancel",
			"k" "event", "cancel",
		    YW_END),
		YW_END),
	    YW_END);

	f->fini = 0; 
	
	ytk_draw(win);
	
	while (!f->fini) {
		YwPacket *pkt;
		
		pkt = ytk_process_events(NULL, -1);
		
		if (pkt)
			yw_packet_free(pkt);
	}
	
	ytk_dec_ref(win);
}

int resp(void *useless, const char *name, YwWord *arg)
{
	void *ptr = NULL;
	
	(void)useless;

	yw_word_fetch_ptr(arg, &ptr);
	
	if (strcmp(name, "exit") == 0) {
		exit(1);
	} else if (strcmp(name, "edit") == 0) {
		update(ptr);
	} else
		return -1;
	
	return 0;
}


int main()
{
	YtkObject *win;
	struct form f[3];
	
	yw_string_assign_cstring(&f[0].name, NULL, "aleph-0", -1);
	yw_string_assign_cstring(&f[0].cpu, NULL, "i586", -1);
	yw_string_assign_cstring(&f[1].name, NULL, "team", -1);
	yw_string_assign_cstring(&f[1].cpu, NULL, "sparc64", -1);
	yw_string_assign_cstring(&f[2].name, NULL, "boniek", -1);
	yw_string_assign_cstring(&f[2].cpu, NULL, "alpha", -1);
	
	ypp_init();
	conn = ytk_init();

	win = ytk_new_va("YppWindow",  
		"p" "connection", conn,
		"p" "responder", ytk_responder(NULL, resp),
		"i" "width", 40,
		"i" "height", 7,
		"g" "title", "YPP Test",
		"i" "spacing", 0,
		"k" "layout", "vertical",
		"p" "child", ytk_new_va("YppButton", 
		    "d" "text", "One",
		    "k" "event", "edit",
		    "p" "event_arg", &f[0],
		YW_END),
		"p" "child", ytk_new_va("YppButton", 
		    "d" "text", "Two",
		    "k" "event", "edit",
		    "p" "event_arg", &f[1],
		YW_END),
		"p" "child", ytk_new_va("YppButton", 
		    "d" "text", "Three",
		    "k" "event", "edit",
		    "p" "event_arg", &f[2],
		YW_END),
		"p" "child", ytk_new_va("YppButton", 
		    "d" "text", "Bye",
		    "k" "event", "exit",
		YW_END),
	YW_END);
	
	ytk_draw(win);
	
	for (;;) {
		YwPacket *pkt;
		
		pkt = ytk_process_events(NULL, -1);
		
		if (pkt)
			yw_packet_free(pkt);
	}
	
	return 0;
}
