#include <typeinfo>
#include <ypp/Packet.h>

namespace Ypp {

void Exception::print()
{
	AsciiString s;

	try {
		s = msg.get_cstring();
	} catch (ConversionException &) {
		s = "[Inconvertable string]";
	}
	
	fprintf(stderr, "Exception: %s: %s\n", 
		typeid(*this).name(),
		s.ref());
}

//
// Next two functions seems quite ugly. However it's partialy
// intended, since set of possible exception, translated to
// messages, should be limited.
//

Packet Exception::get_packet()
{
	const char *name = "oops";
	
	if (typeid(*this) == typeid(ConversionException))
		name = "conversion";
	else if (typeid(*this) == typeid(WordTypeException))
		name = "bad_word_type";
	else if (typeid(*this) == typeid(WordNotFoundException))
		name = "word_not_found";
	else if (typeid(*this) == typeid(MsgNotUnderstoodException))
		name = "msg_not_understood";
	else if (typeid(*this) == typeid(BadMsgArgsException))
		name = "bad_msg_args";
	else if (typeid(*this) == typeid(InvalidTagException))
		name = "invalid_tag";
	else if (typeid(*this) == typeid(NoNextTagException))
		name = "no_next_tag";
	else if (typeid(*this) == typeid(TagNotFoundException))
		name = "tag_no_found";
	else if (typeid(*this) == typeid(OpException))
		name = "op";
	
	return Packet(yw_reply_packet, 
		"k" "error", name, 
		"s", msg.ref(), 
		YW_END);
}

void Exception::throw_packet(const Packet &pkt)
{
  	enum {
		x_ConversionException,
		x_WordTypeException,
		x_WordNotFoundException,
		x_MsgNotUnderstoodException,
		x_BadMsgArgsException,
		x_InvalidTagException,
		x_NoNextTagException,
		x_TagNotFoundException,
		x_OpException,
		x_Exception
	};
	static YwMapEntry e[] = {
		{ "conversion", x_ConversionException },
		{ "bad_word_type", x_WordTypeException },
		{ "word_not_found", x_WordNotFoundException },
		{ "msg_not_understood", x_MsgNotUnderstoodException },
		{ "bad_msg_args", x_BadMsgArgsException },
		{ "invalid_tag", x_InvalidTagException },
		{ "no_next_tag", x_NoNextTagException },
		{ "tag_not_found", x_TagNotFoundException },
		{ "op", x_OpException },
		{ NULL, x_Exception }
	};
	static YwMapCache *cache;
	String msg;
	int type = x_Exception;
	int n = 1;

	if (pkt.length() > 1 && pkt.word(1).type() == yw_key_word) {
		type = pkt.word(1).mapped_keyword(e, &cache);
		if (type != x_Exception)
			n++;
	}

	while (n < pkt.length()) {
		Word w = pkt.word(n++);
		if (w.type() == yw_key_word)
			msg += w.keyword().ref();
		else if (w.type() == yw_string_word)
			msg += w.string();
		else
			break;
		msg += " ";
	}

	switch (type) {
		case x_ConversionException:
			throw ConversionException(msg);
		case x_WordTypeException:
			throw WordTypeException(msg);
		case x_WordNotFoundException:
			throw WordNotFoundException(msg);
		case x_MsgNotUnderstoodException:
			throw MsgNotUnderstoodException(msg);
		case x_BadMsgArgsException:
			throw BadMsgArgsException(msg);
		case x_InvalidTagException:
			throw InvalidTagException(msg);
		case x_NoNextTagException:
			throw NoNextTagException(msg);
		case x_TagNotFoundException:
			throw TagNotFoundException(msg);
		default:
		case x_Exception:
			throw Exception(msg);
	}
}

}
