/* $Id: Window.cc,v 1.2 2001/05/21 09:58:52 malekith Exp $ */

#include <ypp/Window.h>

// Register Window

namespace Ypp {

void Window::draw()
{
	if (no_buf())
		return;
	Group::draw();
	buf.sync();
}

namespace {
	enum {
		op_title,
		op_oops
	};
	YwMapEntry op_e[] = {
		// {class: YppWindow}
		// {super: YppGroup}
		// Window is bridge between client and server.
		// Windows are common to both of them. They include
		// buffer, that can be written into. Widgets won't
		// be ever seen by the user unless you put them into
		// some window.
		// {string} Text displayed in title-bar of window.
		// Note, that this text is displayed by Window Manager,
		// and not Ypp.
		{ "title", op_title },
		// {class: end}
		{ NULL, op_oops },
	};
	YwMapCache *op_cache;
}

Word Window::get_op(const AsciiString &name)
{
	switch (name.map(op_e, &op_cache)) {
	case op_title:
		return title;
	default:
		return Group::get_op(name);
	}
}

void Window::set_op(const AsciiString &name, const Word &w)
{
	enum {
		op_title,
		op_oops
	};
	YwMapEntry e[] = {
		{ "title", op_title },
		{ NULL, op_oops },
	};
	static YwMapCache *cache;
	
	switch (name.map(op_e, &op_cache)) {
	case op_title:
		title = w.string();
		break;
	default:
		Group::set_op(name, w);
	}
}

Window::~Window()
{
	yw_window_close(win);
	win = NULL;
}

Window::Window()
{
	win = NULL;
}

void Window::init(const TagList &t)
{
	static const char *ops[] = {
		"title",
		NULL
	};
	
	Group::init(t);
	
	set_named_ops(ops, t);

	VarSize s = get_sizes();
	int w = preset.mid.w, h = preset.mid.h;
	
	if (w == -1)
		w = s.mid.w;
	if (h == -1)
		h = s.mid.h;

	
	Packet pkt(yw_call_packet, 
		"i" "width", w,
		"i" "height", h,
		"s" "wm_title", title.ref(),
		YW_END);
	
	win = yw_window_new((YwConnection*)t.find("connection").ptr(),
			    (YwPacket*)pkt.ref());
	if (win == NULL)
		throw ObjectException("Cannot create window");
	
	get_self().bind_to_window(win);
	
	set_position(Packet(yw_taglist_packet,
				"i" "pos_x", 0,
				"i" "pos_y", 0,
				"i" "width", w,
				"i" "height", h,
			YW_END));
}

}
