#include <ypp/Object.h>
#include <ypp/TagList.h>

namespace Ypp {

const Object &Object::operator =(const Object &r)
{
	if (&r != this) {
		ytk_dec_ref(obj);
		obj = r.obj;
		ytk_inc_ref(obj);
	}

	return *this;
}

Object::Object(const Object &r)
{
	obj = (YtkObject*)r.obj;
	ytk_inc_ref(obj);
}

Object::Object(const YtkObject *o)
{
	if (o == NULL)
		throw ObjectException("NULL object creation attempt");
	obj = const_cast<YtkObject*>(o);
	ytk_inc_ref(obj);
}

Object::~Object()
{
	ytk_dec_ref(obj);
}

Object::Object(const char *name, const Packet &tags)
{
	obj = ytk_new(name, (YwPacket*)tags.ref());
}

void Object::send_event_up(const AsciiString &name, const Word &val)
{
	Packet p(yw_void_call_packet, "k" "event", name.ref(), YW_END);
	
	p.append(val);

	ytk_object_send_event_up(obj, (YwPacket*)p.ref());
}

Packet Object::send_msg(const Packet &msg)
{
	Packet r = ytk_send_msg(obj, (YwPacket*)msg.ref());
	
	if (r.length() >= 1 && 
	    r.word(0).type() == yw_key_word &&
	    AsciiString(r.word(0).keyword()) == AsciiString("error"))
	    	Exception::throw_packet(r);
	
	return r;
}

Word Object::op(const AsciiString &name)
{
	Packet p;
	
	p = send_msg(Packet(yw_call_packet, "k" "get_op", name.ref(), YW_END));

	// this shouldn't happen, we can either get right response
	// or "error", which is catched by send_msg...
	if (p.word(0).keyword() != "op_value")
		throw OpException("get_op !-> op_value");
	if (p.length() < 2)
		throw OpException("length < 2");
		
	return p.word(1);
}

void Object::set_op(const AsciiString &name, const Word &w)
{
	Packet p(yw_call_packet, "k" "set_op", name.ref(), YW_END);
	p.append(w);
	send_msg(p);
}

void Object::set_op(const Packet &pkt)
{
	for (TagList t(pkt); !t.eot(); t.next()) 
		set_op(t.name(), t.value());
}

YtkObject *Object::steal_ref()
{
	ytk_inc_ref(obj);
	
	return obj;
}

} // namespace Ypp
