/* $Id: Label.cc,v 1.2 2001/05/21 09:58:52 malekith Exp $ */

#include <ypp/Label.h>

// Register Label

namespace Ypp {

namespace {
	enum {
		op_text,
		op_fg_color,
		op_bg_color,
		op_oops
	};
	YwMapEntry op_e[] = {
		// {class: YppLabel}
		// {super: YppWidget}
		// Single-line non-interactive text-displaying widget.
		// {string} Caption of widget.
		{ "text", op_text },
		// {int} Foreground color.
		{ "fg_color", op_fg_color },
		// {int} Backround color.
		{ "bg_color", op_bg_color },
		// {class: end}
		{ NULL, op_oops },
	};
	YwMapCache *op_cache;
}

Word Label::get_op(const AsciiString &name)
{
	switch (name.map(op_e, &op_cache)) {
	case op_text:
		return text;
	case op_fg_color:
		return fg_color;
	case op_bg_color:
		return bg_color;
	default:
		return Widget::get_op(name);
	}
}

void Label::set_op(const AsciiString &name, const Word &w)
{
	switch (name.map(op_e, &op_cache)) {
	case op_text:
		text = w.string();
		break;
	case op_fg_color:
		fg_color = w.integer();
		break;
	case op_bg_color:
		bg_color = w.integer();
		break;
	default:
		Widget::set_op(name, w);
	}
}

void Label::draw()
{
	if (no_buf())
		return;
		
	buf.bgoto(pos_x, pos_y);
	buf.fg(fg_color);
	buf.bg(bg_color);
	buf.bputs(text);
}

Label::Label()
{
	fg_color = YW_COLOR_ANSI_LIGHTGRAY;
	bg_color = YW_COLOR_ANSI_BLACK;
}

void Label::init(const TagList &t)
{
	static const char *ops[] = {
		"text",
		"fg_color",
		"bg_color",
		NULL
	};

	set_named_ops(ops, t);
	
	preset.mid.w = text.length();
	preset.mid.h = 1;
		
	Widget::init(t);
}

}
