/* $Id: Input.cc,v 1.1 2001/05/21 09:58:52 malekith Exp $ */

#include <ypp/Input.h>

// Register Input

namespace Ypp {

namespace {
	enum {
		op_text,
		op_focused_fg_color,
		op_focused_bg_color,
		op_fg_color,
		op_bg_color,
		op_oops
	};
	YwMapEntry op_e[] = {
		// {class: YppInput}
		// {super: YppWidget}
		// Single-line edit box.
		// {string} Caption of widget.
		{ "text", op_text },
		// {int} Foreground color.
		{ "fg_color", op_fg_color },
		// {int} Backround color.
		{ "bg_color", op_bg_color },
		// {int} Foreground color, used when widget has focus.
		{ "focused_fg_color", op_focused_fg_color },
		// {int} Background color, used when widget has focus.
		{ "focused_bg_color", op_focused_bg_color },
		// {class: end}
		{ NULL, op_oops },
	};
	YwMapCache *op_cache;
}

Word Input::get_op(const AsciiString &name)
{
	switch (name.map(op_e, &op_cache)) {
	case op_text:
		return text;
	case op_focused_fg_color:
		return focused_fg_color;
	case op_focused_bg_color:
		return focused_bg_color;
	case op_fg_color:
		return fg_color;
	case op_bg_color:
		return bg_color;
	default:
		return Widget::get_op(name);
	}
}

void Input::set_op(const AsciiString &name, const Word &w)
{
	switch (name.map(op_e, &op_cache)) {
	case op_text:
		text = w.string();
		break;
	case op_focused_fg_color:
		focused_fg_color = w.integer();
		break;
	case op_focused_bg_color:
		focused_bg_color = w.integer();
		break;
	case op_fg_color:
		fg_color = w.integer();
		break;
	case op_bg_color:
		bg_color = w.integer();
		break;
	default:
		Widget::set_op(name, w);
	}
}

void Input::draw()
{
	if (no_buf())
		return;

	buf.bgoto(pos_x, pos_y);
	
	if (get_self().has_focus()) {
		buf.fg(focused_fg_color);
		buf.bg(focused_bg_color);
	} else {
		buf.fg(fg_color);
		buf.bg(bg_color);
	}

	int p = off;
	int save = pos_x;
	
	for (int i = 0; i < width; i++) {
		if (p == pos)
			save = buf.get_x();
		buf.bputchar(p < text.length() ? text[p] : ' ');
		p++;
	}
	
	buf.bgoto(save, pos_y);
}

Input::Input()
{
	fg_color = YW_COLOR_ANSI_BLACK;
	bg_color = YW_COLOR_ANSI_CYAN;
	focused_fg_color = YW_COLOR_ANSI_WHITE;
	focused_bg_color = YW_COLOR_ANSI_CYAN;
	
	pos = off = 0;
}

void Input::fix_offset()
{
	if (pos < 0)
		pos = 0;

	if (pos > text.length())
		pos = text.length();
		
	if (off + width - 1 < pos)
		off = pos - width + 1;
		
	if (off > pos)
		off = pos;
		
	redraw();
}

bool Input::handle_norm_key(const String &str, int flags)
{
	if ((flags & (yw_key_meta | yw_key_ctrl)) ||
	    str[0] < ' ')
	    
		return false;
	// ok, it's seems to be pritable
	text += str;
	
	// now move it, where it's supposed to be
	uint32_t *ptr = (const_cast<YwString*>(text.ref()))->chars;
	yw_memmove(ptr + pos + str.length(), 
		   ptr + pos, 
		   (text.length() - pos - str.length()) * sizeof(uint32_t));
		   
	for (int i = 0; i < str.length(); i++)
		text[pos++] = str[i];
	
	fix_offset();
}

bool Input::handle_spec_key(int key, int flags)
{
	if (flags & (yw_key_meta | yw_key_ctrl))
		return false;
		
	switch (key) {
	case yw_key_left:
		pos--;
		break;
	case yw_key_right:
		pos++;
		break;
	case yw_key_home:
		pos = 0;
		break;
	case yw_key_end:
		pos = text.length();
		break;
	case yw_key_backspace:
		if (pos == 0)
			break;
		pos--;
		// no break
	case yw_key_del:
		if (pos < text.length()) {
			uint32_t *ptr = 
				(const_cast<YwString*>(text.ref()))->chars;
			
			yw_memmove(ptr + pos, 
				   ptr + pos + 1, 
				   (text.length() - pos) * sizeof(uint32_t));
				   
			(const_cast<YwString*>(text.ref()))->len--;
		}
		break;
	default:
		return false;
	}

	fix_offset();
	
	return true;
}

void Input::init(const TagList &t)
{
	static const char *ops[] = {
		"text",
		"focused_fg_color",
		"focused_bg_color",
		"fg_color",
		"bg_color",
		NULL
	};

	set_named_ops(ops, t);
	
	preset.mid.w = 20;
	preset.mid.h = 1;

	Widget::init(t);
}

bool Input::can_get_focus()
{
	return true;
}

}
