/* $Id: Class.cc,v 1.3 2001/05/21 09:58:51 malekith Exp $ */
#include <ytk/ytk.h>
#include <ypp/Class.h>
#include <ypp/TagList.h>

namespace Ypp {

// {class: YppClass}
// {super: NONE} {abstract}
// This class is root of all widgets in Ypp.
// {class: end}

void Class::set_self(YtkObject *s)
{
	yw_assert(self == NULL);

	self = s;
}

Packet Class::dispatch(const Packet &)
{
	throw MsgNotUnderstoodException();
}

YwPacket *Class::global_callback(void *data, YwPacket *msg)
{
	Class *w;
	Packet pkt;

	w = (Class*)data;

	try {
		pkt = w->dispatch(msg);
	} catch (Exception &e) {
		pkt = e.get_packet();
	}
	
	return yw_packet_copy_of(pkt.ref());
}

void Class::global_finalizer(void *data)
{
	Class *w;

	w = (Class*)data;

	delete w;
}

Class::~Class()
{
}

} // namespace Ypp
