/* $Id: Button.cc,v 1.2 2001/05/24 14:53:58 malekith Exp $ */

#include <ypp/Button.h>

// Register Button

namespace Ypp {

namespace {
	enum {
		op_text,
		op_focused_fg_color,
		op_focused_bg_color,
		op_fg_color,
		op_bg_color,
		op_event,
		op_event_arg,
		op_oops
	};
	YwMapEntry op_e[] = {
		// {class: YppButton}
		// {super: YppWidget}
		// Class of buttons, that can be pressed (clicked).
		// They generate event (see event and event_arg properties)
		// and send it to their parent.
		// {string} Text displayed inside the Button.
		{ "text", op_text },
		// {int} Foreground color.
		{ "fg_color", op_fg_color },
		// {int} Backround color.
		{ "bg_color", op_bg_color },
		// {int} Foreground color, used when widget has focus.
		{ "focused_fg_color", op_focused_fg_color },
		// {int} Background color, used when widget has focus.
		{ "focused_bg_color", op_focused_bg_color },
		// {keyword} Name of event to send when button is pressed.
		{ "event", op_event },
		// {any} Argument of event to send when button is pressed.
		{ "event_arg", op_event_arg },
		// {class: end}
		{ NULL, op_oops },
	};
	
	YwMapCache *op_cache;
}

Word Button::get_op(const AsciiString &name)
{
	switch (name.map(op_e, &op_cache)) {
	case op_text:
		return text;
	case op_focused_fg_color:
		return focused_fg_color;
	case op_focused_bg_color:
		return focused_bg_color;
	case op_fg_color:
		return fg_color;
	case op_bg_color:
		return bg_color;
	case op_event:
		return event;
	case op_event_arg:
		return event_arg;
	default:
		return Widget::get_op(name);
	}
}

void Button::set_op(const AsciiString &name, const Word &w)
{
	switch (name.map(op_e, &op_cache)) {
	case op_text:
		text = w.string();
		break;
	case op_focused_fg_color:
		focused_fg_color = w.integer();
		break;
	case op_focused_bg_color:
		focused_bg_color = w.integer();
		break;
	case op_fg_color:
		fg_color = w.integer();
		break;
	case op_bg_color:
		bg_color = w.integer();
		break;
	case op_event:
		event = w.keyword();
		break;
	case op_event_arg:
		event_arg = w;
		break;
	default:
		Widget::set_op(name, w);
	}
}

void Button::draw()
{
	if (no_buf())
		return;

	buf.bgoto(pos_x, pos_y);
	
	if (get_self().has_focus()) {
		buf.fg(focused_fg_color);
		buf.bg(focused_bg_color);
	} else {
		buf.fg(fg_color);
		buf.bg(bg_color);
	}

	
	for (int i = 0; i < width; i++) {
		int ch = ' ';
		if (i == 0)
			ch = '[';
		else if (i == width - 1)
			ch = ']';
		else if (i >= 2 && i - 2 < text.length())
			ch = text[i - 2];
		buf.bputchar(ch);
	}
	
	buf.bgoto(pos_x + 2, pos_y);
}

Button::Button()
{
	fg_color = YW_COLOR_ANSI_GREEN;
	bg_color = YW_COLOR_ANSI_BLACK;
	focused_fg_color = YW_COLOR_ANSI_BLACK;
	focused_bg_color = YW_COLOR_ANSI_GREEN;
	
	event = "button";
	event_arg = "none";
}

bool Button::handle_norm_key(const String &str, int /*flags*/)
{
	if (!(str == " " || str == "\n"))
		return false;
	
	get_self().send_event_up(event, event_arg);

	return true;
}

void Button::init(const TagList &t)
{
	static const char *ops[] = {
		"text",
		"focused_fg_color",
		"focused_bg_color",
		"fg_color",
		"bg_color",
		"event",
		"event_arg",
		NULL
	};

	set_named_ops(ops, t);
	
	// this should be set in context of buffer (to reflect
	// local character approximation width). unfortunetly
	// buffer is unknown at this point :-(
	preset.mid.w = text.length() + 4;
	preset.mid.h = 1;

	Widget::init(t);
}

bool Button::can_get_focus()
{
	return true;
}

} // namespace Ypp
