/* $Id: talk.c,v 1.7 2001/05/11 10:38:05 malekith Exp $ */

#include <yw/util.h>
#include <yw/random.h>
#include <yw/int/conn.h>
#include <yw/int/calls.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static int version_agreement(YwConnection *conn)
{
	char buf[128], id[130];
	int ver, rel;
	int i;

	if (conn->server) {
		sprintf(buf, "Yserver %d.%d %s\n", YW_CUR_PROTO_VER,
			YW_CUR_PROTO_REL, YW_SOFTWARE_VERSION);
		conn->write(conn, buf, strlen(buf));
	}
	
	for (i = 0; i < 100; i++) {
		if (conn->read(conn, buf + i, 1) < 1)
			return -1;
		if (buf[i] == '\n')
			break;
	}

	if (buf[i] != '\n')
		yw_int_return_err(conn, YW_ERR_PROTO);

	buf[i+1] = 0;

	if (sscanf(buf, "%s %d.%d", id, &ver, &rel) != 3)
		yw_int_return_err(conn, YW_ERR_PROTO);

	if (strcmp(id, conn->server ? "Yclient" : "Yserver") != 0)
		yw_int_return_err(conn, YW_ERR_PROTO);
		
	if (ver != YW_CUR_PROTO_VER || rel != YW_CUR_PROTO_REL)
		yw_int_return_err(conn, YW_ERR_VERSION);
		
	if (!conn->server) {
		sprintf(buf, "Yclient %d.%d %s\n", YW_CUR_PROTO_VER,
			YW_CUR_PROTO_REL, YW_SOFTWARE_VERSION);
		conn->write(conn, buf, strlen(buf));
	}

	return (conn->state);
}

uint8_t *yw_int_generate_cookie()
{
	uint8_t *ret;

	ret = yw_malloc(YW_COOKIE_SIZE);
	yw_random_get(ret, YW_COOKIE_SIZE);

	return ret;
}

int yw_int_blocking_read(YwConnection *conn, void *buf, int size)
{
	int pos, r;

	for (pos = 0; pos < size; pos += r) 
		if ((r = conn->read(conn, 
				    (uint8_t*)buf + pos, size - pos)) <= 0)
			return -1;

	return size;
}

static int md5_exchange(YwConnection *conn)
{
	uint8_t buf[YW_COOKIE_SIZE * 2];
	uint8_t md5[16], our_md5[16];
	
	/* first send the cookie */
	conn->write(conn, conn->cookie, YW_COOKIE_SIZE);

	memcpy(buf, conn->authority, YW_COOKIE_SIZE);
	memcpy(buf + YW_COOKIE_SIZE, conn->cookie, YW_COOKIE_SIZE);
	yw_count_md5(our_md5, buf, YW_COOKIE_SIZE * 2);

	/* then get it back */
	if (yw_int_blocking_read(conn, buf + YW_COOKIE_SIZE, 
			      YW_COOKIE_SIZE) != YW_COOKIE_SIZE)
		return -1;
	
	if (!conn->server)
		memcpy(conn->cookie, buf + YW_COOKIE_SIZE, YW_COOKIE_SIZE);
		
	yw_count_md5(md5, buf, YW_COOKIE_SIZE * 2);

	conn->write(conn, md5, 16);

	if (yw_int_blocking_read(conn, md5, 16) != 16)
		return -1;

	if (memcmp(our_md5, md5, 16) != 0)
		yw_int_return_err(conn, YW_ERR_BAD_AUTH);

	memset(buf, 0, sizeof(buf));

	return 0;
}

static int feature_exchange(YwConnection *conn)
{
	static const char features[] = 
		"pkt_conn,"
		"arcfour,"
#ifdef YW_HAS_ZLIB
		"zlib,"
#endif
		"\n";
				
	char buf[200];
	int i;
	
	if (conn->server)
		conn->write(conn, features, strlen(features));
	
	memset(buf, 0, sizeof(buf));
	buf[0] = ',';
	for (i = 1; i < (int)sizeof(buf) - 10; i++) {
		conn->read(conn, buf + i, 1);
		if (conn->state)
			return -1;
		if (buf[i] == '\n')
			break;
	}

	if (buf[i] != '\n')
		yw_int_return_err(conn, YW_ERR_PROTO);

	if (yw_strstr(buf, ",pkt_conn,") == 0)
		yw_int_return_err(conn, YW_ERR_PROTO);
		
	buf[i] = ',';

#ifndef YW_HAS_ZLIB
	if (conn->zlib == YW_YES)
		yw_int_return_err(conn, YW_ERR_NO_ZLIB);
#endif
		
	if (conn->zlib == YW_YES && yw_strstr(buf, ",zlib,") == 0)
		yw_int_return_err(conn, YW_ERR_NO_ZLIB);
		
	if (conn->crypt == YW_YES && yw_strstr(buf, ",arcfour,") == 0)
		yw_int_return_err(conn, YW_ERR_NO_CRYPT);

	if (conn->zlib == YW_MAYBE)
		conn->zlib = yw_strstr(buf, ",zlib,") ? YW_YES : YW_NO;
	if (conn->crypt == YW_MAYBE)
		conn->crypt = yw_strstr(buf, ",arcfour,") ? YW_YES : YW_NO;

	if (!conn->server) {
		sprintf(buf, "pkt_conn,%s%s\n",
			conn->zlib == YW_YES ? "zlib," : "",
			conn->crypt == YW_YES ? "arcfour," : "");
		conn->write(conn, buf, strlen(buf));
	}

	if (conn->crypt == YW_YES)
		yw_int_enable_encryption(conn);

#ifdef YW_HAS_ZLIB
	if (conn->crypt == YW_YES)
		yw_int_enable_zlib(conn);
#endif


	return 0;
}

/* to be used in both client and server */
int yw_int_conversation(YwConnection *conn)
{
	if (version_agreement(conn))
		return conn->state;
		
	conn->cookie = yw_int_generate_cookie();

	if (md5_exchange(conn))
		return conn->state;
		
	if (feature_exchange(conn))
		return conn->state;

	return 0;
}
