/* $Id: server.c,v 1.3 2001/05/05 11:36:18 dobrek Exp $ */

#include <yw/util.h>
#include <yw/server.h>
#include <yw/int/conn.h>
#include <yw/int/calls.h>

#include <string.h>
#include <stdio.h>

uint8_t *yw_serv_generate_authority(int port)
{
	FILE *f;
	YwConnection *conn;
	uint8_t *authority;

	conn = yw_conn_new();
	yw_int_init_rand(conn);
	if (conn->home == 0) {
		fprintf(stderr, "$HOME not set\n");
		exit(1);
	}
	
	authority = yw_int_generate_cookie();

	f = fopen(conn->authority_file, "wb");	
	/* hmmm... maybe 127.0.0.1 || ::1 ? */
	fprintf(f, "%s%%%d\n", "localhost", port);
	fwrite(authority, 1, YW_COOKIE_SIZE, f);
	fclose(f);

	yw_conn_free(conn);

	return authority;
}

YwConnection *yw_serv_new_conn(int fd, uint8_t *authority)
{
	YwConnection *c;

	c = yw_conn_new();
	
	c->authority = yw_malloc(YW_COOKIE_SIZE);
	memcpy(c->authority, authority, YW_COOKIE_SIZE);
	c->server = 1;
	c->state = 0;
	c->sock_fd = fd;

	return c;
}

int yw_serv_auth(YwConnection *c)
{
	yw_int_conversation(c);
	
	return yw_conn_state(c);
}
