/* $Id: keys.c,v 1.2 2001/05/23 08:46:01 malekith Exp $ */

#include <yw/map.h>
#include <yw/keys.h>
#include <stdio.h>
#include <stdlib.h>

static int try_it(YwPacket *pkt, int *flags, YwWord **ww)
{
	const char *cmd;
	int win_id;
	YwWord *w;
	static YwMapEntry e[] = {
		{ "meta", yw_key_meta },
		{ "ctrl", yw_key_ctrl },
		{ NULL, 0 }
	};
	int f = 0;
	
	if (yw_word_fetch_keyword(yw_packet_word(pkt, 0), &cmd) ||
	    (strcmp(cmd, "kbd") != 0 && strcmp(cmd, "wm_kbd") != 0) ||
	    yw_word_fetch_int(yw_packet_word(pkt, 1), &win_id))
		return -1;
		
	w = yw_packet_word(pkt, 2);
	
	if (w == NULL)
		return -1;
		
	while (yw_word_fetch_keyword(w, &cmd) == 0 && yw_word_next(w)) {
		f |= yw_map(cmd, e, NULL);
		w = yw_word_next(w);
	}
	
	if (yw_word_type(w) != yw_string_word &&
	    yw_word_type(w) != yw_key_word)
	    	return -1;
		
	*ww = w;
	if (flags)
		*flags = f;
	return 0;
}

int yw_key_special(YwPacket *pkt, int *key, int *flags)
{
	static YwMapEntry e[] = {
		{ "left", yw_key_left },
		{ "right", yw_key_right },
		{ "up", yw_key_up },
		{ "down", yw_key_down },
		{ "home", yw_key_home },
		{ "end", yw_key_end },
		{ "ins", yw_key_ins },
		{ "del", yw_key_del },
		{ "pgdn", yw_key_pgdn },
		{ "pgup", yw_key_pgup },
		{ "keypad5", yw_key_keypad5 },
		{ "backspace", yw_key_backspace },
		{ NULL, yw_key_unknown }
	};
	static YwMapCache *cache = NULL;
	YwWord *w;
	const char *kw;
	int r;

	if (try_it(pkt, flags, &w))
		return -1;
	if (yw_word_fetch_keyword(w, &kw))
		return -1;
		
	if (kw[0] == 'f' && kw[1] >= '1' && kw[1] <= '9')
		r = yw_key_f0 + atoi(kw + 1);
	else
		r = yw_map(kw, e, &cache);
	
	if (key)
		*key = r;
	
	return 0;
}

int yw_key_normal(YwPacket *pkt, YwString **str, int *flags)
{
	YwWord *w;
	YwString *s = NULL;

	if (try_it(pkt, flags, &w))
		return -1;
	if (yw_word_fetch_string(w, &s))
		return -1;
	
	if (str)
		*str = s;

	return 0;
}
