/* $Id: intmap.c,v 1.1 2001/04/23 09:49:41 malekith Exp $ */

#include <yw/intmap.h>
#include <yw/util.h>

typedef struct YwIntMapEntry_struct YwIntMapEntry;

struct YwIntMapEntry_struct {
	YwIntMapEntry *next;
	int32_t name;
	int32_t value;
};

struct YwIntMap_struct {
	int32_t def;
	YwIntMapEntry **entries;
};

void yw_intmap_set_default(YwIntMap *d, int32_t v)
{
	d->def = v;
}

int32_t yw_intmap_get_default(YwIntMap *d)
{
	return d->def;
}

#define hash(n) (((n) & 0xff) ^ (((n) >> 8) & 0xff))

int32_t yw_intmap_get(YwIntMap *d, int32_t name)
{
	YwIntMapEntry *e;

	for (e = d->entries[hash(name)]; e; e = e->next)
		if (e->name == name)
			return e->value;
	return d->def;
}

void yw_intmap_add(YwIntMap *d, int32_t name, int32_t value)
{
	YwIntMapEntry *e;
	int n;

	n = hash(name);

	for (e = d->entries[n]; e; e = e->next)
		if (e->name == name) {
			e->value = value;
			return;
		}
	
	e = YW_NEW(YwIntMapEntry);
	e->name = name;
	e->value = value;
	e->next = d->entries[n];
	d->entries[n] = e;
}

YwIntMap *yw_intmap_new()
{
	YwIntMap *d;

	d = YW_NEW(YwIntMap);
	d->def = -1;
	d->entries = yw_malloc_0(sizeof(YwIntMapEntry*) * 256);

	return d;
}

void yw_intmap_free(YwIntMap *d)
{
	YwIntMapEntry *e, *n;
	int i;
	
	if (d == NULL)
		return;
	
	for (i = 0; i < 256; i++) {
		for (e = d->entries[i]; e; e = n) {
			n = e->next;
			yw_free(e);
		}
	}

	yw_free(d->entries);
	d->entries = NULL;
	yw_free(d);
}
