/* $Id: hash.c,v 1.1 2001/03/19 16:05:19 malekith Exp $ */

#include <yw/hash.h>
#include <yw/util.h>

#include <string.h>

struct YwHash_struct {
	unsigned int mask;	/* size of tab - 1 */
	unsigned int el;	/* number of elements */ 
	YwHashEntry **tab;
};

static unsigned int hash(const char *name)
{
	unsigned int v = 0;
	
	while (*name) 
		v = 33 * v + (unsigned char)*name++;
		
	return v;
}

void *yw_hash_find(YwHash *h, const char *name)
{
	YwHashEntry *p;
	
	for (p = h->tab[hash(name) & h->mask]; p; p = p->next)
		if (strcmp(p->name, name) == 0)
			break;

	return p;
}

static void yw_hash_rehash(YwHash *h)
{
	unsigned int oldmask, i;
	YwHashEntry **oldtab, *p, *n;

	oldmask = h->mask;
	oldtab = h->tab;
	
	h->mask = (h->mask << 1) + 1;
	h->tab = yw_malloc_0(sizeof(YwHashEntry*) * (h->mask + 1));

	h->el = 0;
	
	if (oldtab == 0)
		return;
		
	for (i = 0; i <= oldmask; i++)
		for (p = oldtab[i]; p; p = n) {
			n = p->next;
			yw_hash_add(h, p);
		}
	yw_free(oldtab);
}

YwHash *yw_hash_new()
{
	YwHash *h;

	h = YW_NEW(YwHash);
	h->tab = 0;
	h->mask = 7;
	yw_hash_rehash(h);

	return h;
}

void yw_hash_free(YwHash *h, YwHashFreeFunc kill_item)
{
	unsigned int i;
	YwHashEntry *p, *n;
	
	if (kill_item) {
		for (i = 0; i <= h->mask; i++)
			for (p = h->tab[i]; p; p = n) {
				n = p->next;
				kill_item(p);
			}
	}
	
	yw_free(h->tab);
	h->tab = 0;
	yw_free(h);
}

void yw_hash_walk(YwHash *h, YwHashWalkFunc walk, void *userdata)
{
	unsigned int i;
	YwHashEntry *p;
	
	for (i = 0; i <= h->mask; i++)
		for (p = h->tab[i]; p; p = p->next) 
			walk(userdata, p);
}

void yw_hash_add(YwHash *h, void *ee)
{
	YwHashEntry *e = (YwHashEntry*)ee;
	int p;

	p = hash(e->name) & h->mask;

	e->next = h->tab[p];
	h->tab[p] = e;
	
	if (++(h->el) > h->mask)
		yw_hash_rehash(h);
}

void *yw_hash_unlink(YwHash *h, const char *name)
{
	YwHashEntry *e, *p;
	int x;

	x = hash(name) & h->mask;
	
	e = h->tab[x];
	
	if (strcmp(e->name, name) == 0) {
		h->tab[x] = e->next;
		return e;
	}

	while (e->next && strcmp(e->next->name, name))
		e = e->next;

	if (e->next == 0)
		return 0;

	p = e->next;
	e->next = p->next;

	return p;
}
