/* $Id: flags.c,v 1.3 2001/05/04 11:04:23 malekith Exp $ */

#include <yw/util.h>
#include <yw/int/conn.h>

#include <string.h>

/* FIXME: move fetching of $ENV here, from yw_conn_open().
 * yw_conn_setflag(conn, 0, 0) should set everything which is
 * not already set to defaults
 */
 
#define FLAG_STRING	1
#define FLAG_TRISTATE	2
#define FLAG_BOOL	3

struct flag {
	const char *name;
	int type;
	int off;
};

#define off(a) (((char*)&((YwConnection*)0)->a) - (char*)0)

/**
 * {simple: yw/sock.h: set various connection parameters}
 * 
 *   Set flag <a>name</a> for connection <a>conn</a> to value <a>val</a>.
 *  </para>
 *  <para>
 *   Tristate flag is one of "<literal>yes</literal>", "<literal>no</literal>"
 *   or "<literal>maybe</literal>", and always defaults to 
 *   "<literal>maybe</literal>", which means not to require feature, 
 *   but use it if available.
 *  </para>
 *  <para>
 *   PRNG is Pseudo-Random Number Generator. The one used in libyw
 *   implementation is good one, using MD5 hash on big entropy
 *   pool. See yw_random_add(3) for more details.
 *  </para>
 *  <para>
 *   Flags defined at the moment:
 *    <itemizedlist>
 *     <listitem>
 *      <para>
 *       <symbol>ZLIB</symbol> - tristate option to enable/disable zlib link
 *       compression.
 *      </para>
 *     </listitem>
 *     <listitem>
 *      <para>
 *       <symbol>CRYPT</symbol> - tristate option to enable/disable link 
 *       encryption.
 *      </para>
 *     </listitem>
 *     <listitem>
 *      <para>
 *       <symbol>HOME</symbol> - user's home directory, used for default 
 *       values for other options. It defaults to getenv("HOME").
 *      </para>
 *     </listitem>
 *     <listitem>
 *      <para>
 *       <symbol>AUTHORITY</symbol> - file to fetch authentication
 *       information from. It defaults to getenv("YAUTHORITY"), and if that 
 *       fails to <filename>HOME/.Yauthority</filename>.
 *      </para>
 *     </listitem>
 *     <listitem>
 *      <para>
 *       <symbol>DISPLAY</symbol> - string in form <replaceable
 *       >host</replaceable><literal>%</literal><replaceable
 *       >port</replaceable>, where <replaceable>host</replaceable>
 *       can be IPv4 or IPv6 hostname or IP number. It defaults
 *       to getenv("YDISPLAY"), and if that fails to value
 *       from authority file (which, in most cases will be
 *       <literal>localhost%</literal><replaceable>port</replaceable>).
 *      </para>
 *     </listitem>
 *     <listitem>
 *      <para>
 *       <symbol>RANDFILE</symbol> - value of file, from which fetach some
 *       random junk for PRNG initiazlization. It defaults to 
 *       getenv("RANDFILE"), and if that fails to 
 *       <filename>/dev/urandom</filename>.
 *      </para>
 *     </listitem>
 *     <listitem>
 *      <para>
 *       <symbol>RANDSEED</symbol> - file in which to store PRNG state.
 *       It defaults to getenv("YRANDSEED"), and if that fails to 
 *       <filename>HOME/.Yrandseed</filename>.
 *      </para>
 *     </listitem>
 *     <!--
 *     <listitem>
 *      <para>
 *       <symbol></symbol> - 
 *       It defaults to getenv("Y"), and if that fails to HOME/
 *      </para>
 *     </listitem>
 *     <listitem>
 *      <para>
 *       <symbol></symbol> -
 *      </para>
 *     </listitem>
 *     -->
 *    </itemizedlist>
 *
 *   {retval}
 *   {this} returns 0 for success or one of the following values in 
 *   case of error:
 *    <itemizedlist>
 *     <listitem>
 *      <para>
 *       <symbol>YW_ERR_BAD_FLAG</symbol> - wrong 
 *       <replaceable>flag</replaceable>
 *       parameter value.
 *      </para>
 *     </listitem>
 *     <listitem>
 *      <para>
 *       <symbol>YW_ERR_BAD_VALUE</symbol> - wrong <replaceable
 *       >value</replaceable> parameter value. This can only happen 
 *       for tristate options.
 *      </para>
 *     </listitem>
 *    </itemizedlist>
 *
 *  {see: yw_conn_new(3), yw_conn_open(3), getenv(3)}
 */
int yw_conn_set_flag(YwConnection *conn, const char *name, const char *val)
{
	struct flag flags[] = {
		{ "AUTHORITY", FLAG_STRING, off(authority_file) },
		{ "DISPLAY", FLAG_STRING, off(display) },
		{ "HOME", FLAG_STRING, off(home) },
		{ "RANDFILE", FLAG_STRING, off(random_file) },
		{ "RANDSEED", FLAG_STRING, off(randseed) },
		{ "ZLIB", FLAG_TRISTATE, off(zlib) },
		{ "CRYPT", FLAG_TRISTATE, off(crypt) },
		{ 0, 0, 0 }
	};
	int i;

	for (i = 0; flags[i].name; i++)
		if (strcmp(name, flags[i].name) == 0)
			break;

	if (flags[i].name == 0)
		return YW_ERR_BAD_FLAG;

	switch (flags[i].type) {
	case FLAG_STRING:
		yw_setstr((char**)((char*)conn + flags[i].off), val);
		break;
	case FLAG_TRISTATE:
	case FLAG_BOOL:
		if (strcmp(val, "yes") == 0)
			i = YW_YES;
		else if (strcmp(val, "no") == 0)
			i = YW_NO;
		else if (flags[i].type == FLAG_BOOL &&
			 strcmp(val, "maybe") == 0)
			i = YW_MAYBE;
		else
			return YW_ERR_BAD_VALUE;
		*((int*)((char*)conn + flags[i].off)) = i;
		break;
	default:
		yw_halt();
	}

	return 0;
}
