/* $Id: error.c,v 1.3 2001/05/04 11:04:23 malekith Exp $ */

#include <yw/util.h>

static char *errors[-(YW_LAST_ERROR)] = {
	"Success",
	"End of File",
	"$HOME not set",
	"Already connected",
	"Authority file not found",
	"Authority file corrupted",
	"Socket error",
	"Protocol violation",
	"Authorization failed",
	"Bad version",
	"Zlib compression not supported",
	"Link encryption not supported",
	"Bad flag",
	"Bad value",
	"Connection lost",
	"Not connected",
	"Unsupported encoding",
	"Invalid multibyte sequence",
	"Write error",
	"Read error",
	"Zlib error",
};

/**
 * {simple: yw/error.h: translate libyw error code to string}
 * {this} translates libyw error code to UTF8 human readable string.
 * In current implementation they are in English only, but this may
 * change in future. Note that &lt;<filename>yw/error.h</filename>&gt; is
 * included by &lt;<filename>yw/util.h</filename>&gt;.
 * {retval} Pointer to static buffer is returned. It's safe to assume
 * that it's only valid until next call to this function.
 */
const char *yw_strerror(int err_code)
{
	err_code = -err_code;
	if (err_code < 0)
		return "No error";
	else if (err_code < -(YW_LAST_ERROR))
		return errors[err_code];
	else
		return "Unknown error";
}
