/* $Id: display.c,v 1.5 2001/05/04 11:04:22 malekith Exp $ */

#include <yw/display.h>
#include <yw/map.h>
#include <yw/util.h>
#include <yw/buffer.h>
#include <yw/int/packet.h>

void yw_display_send_caps(YwDisplayCallbacks *cb)
{
	int i;
	static struct {
		char *name;
		int flag;
	} caps[] = {
		{ "color", YW_DISPLAY_CAP_COLOR },
		{ "boldface", YW_DISPLAY_CAP_BOLDFACE },
		{ "underline", YW_DISPLAY_CAP_UNDERLINE },
		{ "high_bg", YW_DISPLAY_CAP_UNDERLINE },
		{ "mouse", YW_DISPLAY_CAP_MOUSE },
		{ 0, 0 }
	};
	YwConnection *conn;

	conn = cb->conn;
	
	yw_conn_send_and_free(conn, yw_packet_make(yw_void_call_packet,
		"k", "i_am",
		"k", "display",
	YW_END));
	
	for (i = 0; caps[i].name; i++)
		yw_conn_send_and_free(conn, 
			yw_packet_make(yw_void_call_packet,
			"k", "have_cap",
			"k", caps[i].name,
			"k", (cb->caps & caps[i].flag) ? "yes" : "no",
		YW_END));
		
	yw_conn_send_and_free(conn, yw_packet_make(yw_void_call_packet,
		"k", "have_cap",
		"i" "width", cb->width,
	YW_END));
	
	yw_conn_send_and_free(conn, yw_packet_make(yw_void_call_packet,
		"k", "have_cap",
		"i" "height", cb->height,
	YW_END));
	
	yw_conn_send_and_free(conn, yw_packet_make(yw_void_call_packet,
		"k", "have_cap",
		"v" "end",
	YW_END));
}

static void do_cw(YwDisplayCallbacks *cb, YwWord *w)
{
	YwPacket *pkt;
	YwString str, *ws;
	int width;

	pkt = yw_packet_make(yw_reply_packet, "k", "char_width", YW_END);
	
	for (; (w); w = yw_word_next(w)) {
		if (yw_word_fetch_string(w, &ws)) {
			yw_packet_append_keyword(pkt, "error");
			yw_packet_append_keyword(pkt, "no-value");
			continue;
		}

		width = cb->char_width(cb, ws->chars[0]);
		yw_string_assign_one_char(&str, ws->chars[0]);
		yw_packet_append_string(pkt, &str);
		yw_string_free(&str);
		if (width == -1)
			yw_packet_append_keyword(pkt, "none");
		else
			yw_packet_append_int(pkt, width);
	}

	yw_conn_send_and_free(cb->conn, pkt);
}

char *yw_display_dispatch_packet(YwDisplayCallbacks *cb, YwPacket *pkt)
{
	YwWord *w, *a1, *a2;
	YwMapCache *c = NULL;
	int tmp;
	enum {
		x_noop,
		x_goto,
		x_print,
		x_attr,
		x_char_width,
		x_quit,
		x_refresh
	};
	YwMapEntry e[] = {
		{ "goto", x_goto },
		{ "print", x_print },
		{ "attr", x_attr },
		{ "refresh", x_refresh },
		{ "char_width", x_char_width },
		{ "quit", x_quit },
		{ NULL, x_noop }
	};
	
	w = yw_packet_word(pkt, 0);
	if (w == NULL || w->type != yw_key_word)
		return "no command";

	a1 = yw_packet_word(pkt, 1);
	a2 = yw_packet_word(pkt, 2);
	
	switch (yw_map(w->val.ascii, e, &c)) {
	case x_noop:
		return "unknown command";
	case x_goto:
		if (a1 == NULL || a1->type != yw_int_word ||
		    a2 == NULL || a2->type != yw_int_word)
		    	return "goto: bad args";
		cb->do_goto(cb, a1->val.i, a2->val.i);
		break;
	case x_print:
		if (a1 == NULL || a1->type != yw_string_word)
		    	return "print: bad args";
		cb->do_print(cb, &a1->val.string);
		break;
	case x_attr:
		if (a1 == NULL || a1->type != yw_key_word ||
		    a2 == NULL || a2->type != yw_int_word)
		    	return "attr: bad args";
		tmp = yw_bufattr_from_keyword(a1->val.ascii);
		if (tmp == yw_bufattr_bad)
			return "attr: bad attribute";
		cb->do_attr(cb, (YwBufAttr)tmp, a2->val.i);
		break;
	case x_refresh:
		if (cb->do_flush)
			cb->do_flush(cb);
		break;
	case x_quit:
		if (cb->do_quit)
			cb->do_quit(cb);
		break;
	case x_char_width:
		do_cw(cb, a1);
		break;
	}

	return NULL;
}

