/* $Id: charset.c,v 1.8 2001/05/07 10:25:52 malekith Exp $ */

#include <yw/util.h>
#include <iconv.h>
#include <errno.h>
#include <string.h>

const char *yw_default_encoding = NULL;	

/* ough... how much ugly ifdefs... only becouse iconv doesn't
 * support UCS4 in host endian... */
int yw_convert( const char *src_enc, const void *srcp, int src_len,
		const char *dest_enc, void **destp, int *dest_len )
{
	iconv_t cd;
	char buf[256];
	char *dst;
	const char *src;
	int len = 0, i;
	size_t in_left, out_left;
	/* FIXME: to be detrmined by ./configure */
	static const char *utf32_he_tab[] = { "UCS-4"
#if YW_HOST_ENDIAN == YW_BIG_ENDIAN
		"BE"
#elif YW_HOST_ENDIAN == YW_LITTLE_ENDIAN
		"LE"
#endif
		,
		"UCS4"		/* it's bigendian... */
		,
		NULL
	};
	static const char *utf32_he = NULL;
#if YW_HOST_ENDIAN != YW_BIG_ENDIAN
	static int need_byte_swap = 0;
	int swap_dst = 0;
	void *free_me = NULL;
#endif

	if (utf32_he == NULL) {
		for (i = 0; utf32_he_tab[i]; i++) {
			utf32_he = utf32_he_tab[i];
			cd = iconv_open(utf32_he, "UTF8");
#if YW_HOST_ENDIAN != YW_BIG_ENDIAN
			if (i > 0)
				need_byte_swap++;
#endif
			if (cd != (iconv_t)-1) {
				iconv_close(cd);
				break;
			}
		}
		/* FIXME... */
		yw_assert(utf32_he);
	}
	
	if (strcmp(src_enc, YW_UTF32_HE) == 0) {
#if YW_HOST_ENDIAN != YW_BIG_ENDIAN
		if (need_byte_swap) {
			free_me = yw_malloc(src_len);
			memcpy(free_me, srcp, src_len);
			yw_swap_bytes(free_me, src_len / sizeof(uint32_t));
			srcp = free_me;
		}
#endif
		src_enc = utf32_he;
	}
	if (strcmp(dest_enc, YW_UTF32_HE) == 0) {
#if YW_HOST_ENDIAN != YW_BIG_ENDIAN
		swap_dst = need_byte_swap;
#endif
		dest_enc = utf32_he;
	}
		
	if (yw_default_encoding == NULL)
		yw_default_encoding = yw_get_default_encoding();
		
	cd = iconv_open(dest_enc, src_enc);
	
	if (cd == (iconv_t)(-1))
		return YW_ERR_UNSUPPORTED_ENC;

	/* first compute length */

	src = srcp;
	in_left = src_len;
	do {
		errno = 0;
		dst = buf;
		out_left = sizeof(buf);
		iconv(cd, (void*)&src, &in_left, &dst, &out_left);
		len += sizeof(buf) - out_left;
		if (errno && errno != E2BIG) {
			iconv_close(cd);
#if YW_HOST_ENDIAN != YW_BIG_ENDIAN
			yw_free(free_me);
#endif
			return YW_ERR_BAD_ENC_DATA;
		}
	} while (errno);

	/* malloc() and convert at once */
	*destp = dst = yw_malloc_0(len + 4);
	src = srcp;
	in_left = src_len;
	/* glibc 2.1 is heavily broken here, and bombs when given exact
	 * number of characters... */
	out_left = len + 1;

	if (dest_len)
		*dest_len = len;
		
	iconv(cd, NULL, NULL, NULL, NULL);
	if (iconv(cd, (void*)&src, &in_left, &dst, &out_left) == (size_t)-1)
		yw_halt();

	iconv_close(cd);

#if YW_HOST_ENDIAN != YW_BIG_ENDIAN
	yw_free(free_me);
	
	if (swap_dst)
		yw_swap_bytes(*destp, len / sizeof(uint32_t));
#endif
	
	return 0;
}
