/* $Id: char_width.c,v 1.1 2001/05/04 11:04:22 malekith Exp $ */

#include <yw/int/conn.h>
#include <yw/intmap.h>
#include <yw/unigfx.h>
#include <yw/lock.h>
#include <yw/util.h>

typedef struct YwCharWidths_struct YwCharWidths;

struct YwCharWidths_struct {
	YwIntMap *map;
};

/* count length of *entire* string str, not only the first character */
int yw_conn_string_width(YwConnection *conn, const YwString *str)
{
	int len, i, r;
	yw_conn_cache_widths(conn, str);

	for (i = 0, len = 0; i < str->len; i++)
		if ((r = yw_conn_char_width(conn, str->chars[i])) >= 0)
			len += r;
		else
			return -1;	/* ??? */
	
	return len;
}

/* 127 ASCII characters, and all characters in <yw/unigfx.h>, maybe more */
YwString *yw_get_precache()
{
	static uint32_t semigfx[] = {
	YW_UNIGFX_BOX_H, YW_UNIGFX_BOX_V, YW_UNIGFX_BOX_D_R,
	YW_UNIGFX_BOX_D_L, YW_UNIGFX_BOX_U_R, YW_UNIGFX_BOX_U_L,
	YW_UNIGFX_BOX_V_R, YW_UNIGFX_BOX_V_L, YW_UNIGFX_BOX_D_H,
	YW_UNIGFX_BOX_U_H, YW_UNIGFX_BOX_V_H, YW_UNIGFX_BOX_DH,
	YW_UNIGFX_BOX_DV, YW_UNIGFX_BOX_D_DR, YW_UNIGFX_BOX_DD_R,
	YW_UNIGFX_BOX_DD_DR, YW_UNIGFX_BOX_D_DL, YW_UNIGFX_BOX_DD_L,
	YW_UNIGFX_BOX_DD_DL, YW_UNIGFX_BOX_U_DR, YW_UNIGFX_BOX_DU_R,
	YW_UNIGFX_BOX_DU_DR, YW_UNIGFX_BOX_U_DL, YW_UNIGFX_BOX_DU_L,
	YW_UNIGFX_BOX_DU_DL, YW_UNIGFX_BOX_V_DR, YW_UNIGFX_BOX_DV_R,
	YW_UNIGFX_BOX_DV_DR, YW_UNIGFX_BOX_V_DL, YW_UNIGFX_BOX_DV_L,
	YW_UNIGFX_BOX_DV_DL, YW_UNIGFX_BOX_D_DH, YW_UNIGFX_BOX_DD_H,
	YW_UNIGFX_BOX_DD_DH, YW_UNIGFX_BOX_U_DH, YW_UNIGFX_BOX_DU_H,
	YW_UNIGFX_BOX_DU_DH, YW_UNIGFX_BOX_V_DH, YW_UNIGFX_BOX_DV_H,
	YW_UNIGFX_BOX_DV_DH, YW_UNIGFX_BLOCK_MIDDLE, YW_UNIGFX_BLOCK_UP,
	YW_UNIGFX_BLOCK_DOWN, YW_UNIGFX_BLOCK, YW_UNIGFX_FILL_0,
	YW_UNIGFX_FILL_1, YW_UNIGFX_FILL_3, YW_UNIGFX_FILL_4,
	YW_UNIGFX_FILL_5, YW_UNIGFX_ARROW_LEFT, YW_UNIGFX_ARROW_UP,
	YW_UNIGFX_ARROW_RIGHT, YW_UNIGFX_ARROW_DOWN, YW_UNIGFX_ARROW_UP_B,
	YW_UNIGFX_ARROW_UP_W, YW_UNIGFX_ARROW_RIGHT_B, YW_UNIGFX_ARROW_RIGHT_W,
	YW_UNIGFX_ARROW_DOWN_B, YW_UNIGFX_ARROW_DOWN_W, YW_UNIGFX_ARROW_LEFT_B,
	YW_UNIGFX_ARROW_LEFT_W, YW_UNIGFX_DIAMOND, YW_UNIGFX_DIAMOND_E,
	YW_UNIGFX_BULLET, 0
	};
	uint32_t tab[256 + sizeof(semigfx) / sizeof(semigfx[0]) + 100];
	int p, i, j;
	static YwString *ret, buf;
	static YwLock lock = YW_LOCK_INIT;

	yw_lock(&lock);
	if (ret) {
		yw_unlock(&lock);
		return ret;
	}

	p = 0;
	for (i = ' '; i <= 127; i++)
		tab[p++] = i;
	for (i = 0; semigfx[i]; i++)
		tab[p++] = semigfx[i];
	/* more ? */
	
	for (i = 0; i < p; i++) {
		for (j = 0; j < i; j++)
			if (tab[j] == tab[i]) {
				tab[i] = 0;
				break;
			}
	}

	j = 0;
	for (i = 0; i < p; i++)
		if (tab[i])
			tab[j++] = tab[i];
	
	yw_string_assign_utf32(&buf, tab, j);
	ret = &buf;
	yw_unlock(&lock);

	return ret;
}

void yw_conn_cache_widths(YwConnection *conn, const YwString *str)
{
	YwCharWidths *cw = conn->cw;
	YwString all, one, *r;
	YwString *s;
	int i, j;
	YwPacket *pkt;
	YwWord *w;
	const char *dummy;
	
	yw_string_assign_string(&all, str);
	
	if (cw == NULL) {
		cw = YW_NEW_0(YwCharWidths);
		cw->map = yw_intmap_new();
		yw_intmap_set_default(cw->map, -2);
		conn->cw = cw;

		s = yw_get_precache();

		for (i = 0; i < all.len; i++)
			if (yw_string_idx(s, all.chars[i]) != -1)
				all.chars[i] = 0;
		yw_string_concat(&all, s);
	}

	
	for (i = 0; i < all.len; i++)
		if (yw_intmap_get(cw->map, all.chars[i]) != -2)
			all.chars[i] = 0;
			
	j = 0;
	for (i = 0; i < all.len; i++)
		if (all.chars[i])
			all.chars[j++] = all.chars[i];
			
	if ((all.len = j) == 0)
		return;
	
	pkt = yw_packet_make(yw_call_packet, "k", "char_width", YW_END);
	
	for (i = 0; i < all.len; i++) {
		yw_string_assign_one_char(&one, all.chars[i]);
		yw_packet_append_string(pkt, &one);
		yw_string_free(&one);
	}
	
	yw_conn_send_and_free(conn, pkt);

	pkt = yw_conn_recv_reply(conn, -1);
	
	if (pkt)
		for (w = yw_packet_word(pkt, 1); w; w = yw_word_next(w)) {
			if (yw_word_fetch_string(w, &r))
				break;
			w = yw_word_next(w);
			i = -1;
			if (yw_word_fetch_int(w, &i) &&
			    yw_word_fetch_keyword(w, &dummy))
			    	break;
			yw_intmap_add(cw->map, r->chars[0], i);
		}
	
	yw_string_free(&all);
	yw_packet_free(pkt);
}

int yw_conn_char_width(YwConnection *conn, uint32_t ch)
{
	YwCharWidths *cw = conn->cw;

	if (cw == NULL || yw_intmap_get(cw->map, ch) == -2) {
		YwString str;
		
		yw_string_assign_one_char(&str, ch);
		yw_conn_cache_widths(conn, &str);
		yw_string_free(&str);

		cw = conn->cw;
	}

	return yw_intmap_get(cw->map, ch);
}
