#!/usr/bin/perl -w

sub dmp($)
{
	my $n = shift;
	local $_;
	
	open (DMP, "< $n");
	while (<DMP>) {
		print MANS $_;
	}
}

open(OUT, "> index.xml");
open(MANS, "> manuals.docb");

print OUT qq{<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE chapter PUBLIC "-//OASIS//DTD DocBook XML V4.1//EN" 
	"file:///usr/share/sgml/docbook/xml-dtd-4.1/docbookx.dtd" [
};

open(IDX, "< gen/INDEX") or die;
while (<IDX>) {
chomp;
print OUT qq{<!ENTITY $_ SYSTEM "gen/$_.xml">\n};
}
close(IDX);

print OUT qq{
<!ENTITY yw_INTRO SYSTEM "yw_INTRO.xml">
<!ENTITY catidx SYSTEM "cat_idx.xml">
<!ENTITY slash "/">
]>

 <chapter>
  <title>Manuals</title>
   &yw_INTRO;
};

print MANS qq{
 <chapter>
  <title>Manuals</title>
};
dmp("yw_INTRO.xml");

open(IDX, "< categories");
while (<IDX>) {
	chomp;
	push @cat, $_;
}
close(IDX);
open(IDX, "< gen/INDEX");
while (<IDX>) {
	chomp;
	push @funcs, $_;
	print OUT qq{   &$_;\n};
	dmp("gen/$_.xml");
}
close(IDX);

print MANS "</chapter>\n";

print OUT qq{
 </chapter>
};

open(OUT, "> cat_idx.xml");

print OUT "<itemizedlist>\n";

foreach (@cat) {
/([^\t ]+)\s+(.*)/;
$re = $1;
$desc = $2;
print OUT <<EOF
  <listitem>
   <para>
    $desc:
     <itemizedlist>
EOF
;

	for ($i = 0; $i < @funcs; $i++) {
		$_ = $funcs[$i];
		next if ($_ eq "");
		/$re/ || next;
		print OUT <<EOF
      <listitem>
       <para>
        <citerefentry>
         <refentrytitle>$_</refentrytitle><manvolnum>3</manvolnum>
        </citerefentry>
       </para>
      </listitem>
EOF
;
		$funcs[$i] = "";
	}
print OUT <<EOF
     </itemizedlist>
   </para>
  </listitem>
EOF
;
}

print OUT "</itemizedlist>\n";

