#!/usr/bin/perl -w

$vol = 3;

$st=0;

sub init_sec($)
{
  if($simple && $cursec!=-1) {
    $sections[$cursec] .= "</para>";
  }
  $cursec++;
  $sections[$cursec] = "    <title>$_[0]</title>\n";
  if($simple) {
    $sections[$cursec] .= "<para>\n";
  }
}

sub init()
{
  $cursec = -1;
  @sections = ();
  $includes = "";
  $purp = "";
  $see = "";
  $simple = 0;
}

sub fini()
{
  $proto = "";
  while (<>) {
    chomp;
    $proto .= $_;
    $proto =~ s/\s*{\s*$// and last;
  }

  $proto =~ /([A-Za-z_][A-Za-z_0-9]*(\s*\*)*\s*)([A-Za-z_][A-Za-z_0-9]*)\s*\(([^)]*)\)\s*$/ or die;
  $ret = $1;
  $name = $3;
  $args = $4;
  $includes =~ s/^\s*//;
  @includes = split /\s+/, $includes;
  
  print "$name\n";
  
  print IDX "$name\n";
  
  open(OUT,"> $name.xml");
  print OUT qq{<refentry>
 <refmeta>
  <refentrytitle>$name</refentrytitle>
  <manvolnum>$vol</manvolnum>
 </refmeta>
 
 <refnamediv>
  <refname>$name</refname>
  <refpurpose>$purp</refpurpose>
 </refnamediv>
 <refsynopsisdiv>
  <funcsynopsis>
   <funcsynopsisinfo>
};

  foreach (@includes) {
    print OUT qq{     #include &lt;$_&gt;\n};
  }

  print OUT qq{   </funcsynopsisinfo>
   <funcprototype>
    <funcdef>$ret$name</funcdef>
    <paramdef>};

  @args = split /\s*,\s*/, $args;

  $first=1;
  foreach (@args) {
    /(.*?)([a-z_A-Z][0-9a-z_A-Z]*)$/;
    print OUT ",\n\t\t" unless ($first);
    $first = 0;
    if (defined $2) {
      print OUT "$1<replaceable>$2</replaceable>";
    } else {
      print OUT "$1";
    }
  }

  print OUT qq{</paramdef>
   </funcprototype>
  </funcsynopsis>
 </refsynopsisdiv>

};

  init_sec("dummy");
  for ($i=0;$i<$cursec;$i++) {
    print OUT qq{
   <refsect1>
$sections[$i]
   </refsect1>
   
};
  }

  if ($see ne "") {
    $see =~ s/^\s*//;
    $see =~ s/,/ /g;
    @see = split /\s+/, $see;
    print OUT qq{
 <refsect1>
   <title>SEE ALSO</title>
   <para>
};
    foreach (@see) {
      $fn=$_;
      $vol=3;
      /([a-z][a-z_0-9]*)\(([13])\)/ and do {$fn=$1;$vol=$2; };
      print OUT qq{
 <citerefentry>
  <refentrytitle>
   <function>$fn</function>
  </refentrytitle>
  <manvolnum>$vol</manvolnum>
 </citerefentry>,
};
  }
  
  print OUT qq{  </para>
 </refsect1>
};

    }

  print OUT qq{
 <refsect1>
   <title>INFO</title>
   <para>
     Generated from: $id.
   </para>
 </refsect1>
</refentry>
};


  close(OUT);

}

sub init_class($)
{
  $class_name=shift;
  $super_class=undef;
  $class_desc="";
  $prop_mode = 0;
  $cur_prop = 0;
  $abstract = 0;
  @properties = ();
}

sub fini_class()
{
  print "$class_name\n";
  
  print IDX "$class_name\n";
  
  open(OUT,"> $class_name.xml");
  print OUT qq{<refentry>
 <refmeta>
  <refentrytitle>$class_name</refentrytitle>
  <manvolnum>$vol</manvolnum>
 </refmeta>
 
 <refnamediv>
  <refname>$class_name</refname>
  <refpurpose>$class_name widget</refpurpose>
 </refnamediv>
};


  if ($abstract) {
    $abstract = "$class_name is an abstract class.";
  } else {
    $abstract = "";
  }
  print OUT qq{
   <refsect1>
    <title>METAINFORMATION</title>
    <para>
     $class_name is derived from 
      <citerefentry>
       <refentrytitle>
        <function>$super_class</function>
       </refentrytitle>
       <manvolnum>$vol</manvolnum>
      </citerefentry>. $abstract
      This manpage is generated from: $id.
    </para>
   </refsect1>
   
   <refsect1>
    <title>DESCRIPTION</title>
    <para>
      $class_desc
    </para>
   </refsect1>

};

  if ($prop_mode) {
  print OUT qq{
   <refsect1>
    <title>PROPERTIES</title>
    <para>
     <itemizedlist>
};

  for ($i=0; $i<$cur_prop; $i++) {
    $properties[$i] =~ /([A-Za-z0-9_]+):([A-Za-z0-9_]+):(.*)/;
    print OUT qq{
      <listitem>
       <para>
        $2 <symbol>$1</symbol>: $3
       </para>
      </listitem>
};
    }
    
    print OUT qq{
     </itemizedlist>
    </para>
   </refsect1>
};
  }
  
  print OUT qq{</refentry>\n};
  close(OUT);
}

$id = "";

open(IDX, "| sort > INDEX");
while (<>) {
  # put Id in () to protect from CVS :^)
  /\$(Id:)\s*(.*?)\s*\$/ and $id = $2;
  if ($st==1) {
    chomp;
    if (/\*\//) {fini();$st=0;}
    else {
      s/^ \* ?//;
      s/{simple:\s*([^:]+):\s*([^}]*)}/{include: $1} {short:$2} {desc}/ and $simple = 1;
      s/{desc}/{sect:DESCRIPTION}/;
      s/{retval}/{sect:RETURN VALUE}/;
      s/{bugs}/{sect:BUGS}/;
      s/{notes}/{sect:NOTES}/;
      s/{this}/This function/g;
      s/(\s|^)NULL(\s|$)/$1<symbol>NULL<\/symbol>$2/g;
      s/(\s|^)([a-z_][0-9a-z_]+)\(\)(\s|$)/<function>$2()<\/function>/g;
      s/<(\/?)a>/<$1replaceable>/g;
      s/{include:([^}]*)}//g and $includes .= "$includes $1";
      s/{short:([^}]*)}//g and $purp = $1;
      s/{see:([^}]*)}//g and $see = $1;
      s/([a-z][a-z_0-9]*)\(([13])\)/<citerefentry><refentrytitle><function
>$1<\/function><\/refentrytitle><manvolnum>$2<\/manvolnum><\/citerefentry>/g;
      $line = $_;
      $line =~ s/{sect:([^}]*)}//g and init_sec($1);
      if ($cursec == -1) {
      	die unless ($line =~ /^\s*$/);
      } else {
        $sections[$cursec] .= "    $line\n";
      }
    }
  } elsif (/^\/\*\*$/) {
    $st=1;
    init();
  } elsif (/^\s*\/\/ {class:\s*([A-Z][A-Za-z_0-9]*)}\s*$/) {
    $st=3;
    init_class($1);
  } elsif ($st == 3) {
    chomp;
    if (/\/\/ {class:\s*end}/) {
      $st = 0;
      fini_class();
    } elsif ($prop_mode and /^\s*{\s*"([a-z_0-9A-Z]+)"/) {
      $properties[$cur_prop] = "$1:$properties[$cur_prop]";
      $cur_prop++;
    } elsif (/^\s*\/\/ (.*)$/) {
      $_ = $1;

      s/{abstract}// and $abstract = 1;
      s/{super:\s*([A-Za-z_0-9]+)}// and $super_class = $1;
      
      if (/{(int|string|keyword|ptr|any)}\s*(.*)/) {
        $properties[$cur_prop] = "$1:$2";
	$prop_mode = 1;
      } elsif ($prop_mode) {
        $properties[$cur_prop] .= "\n$_";
      } else {
        $class_desc .= "\n$_";
      }
    }
  }
} continue {
  close ARGV if eof;
}

close(IDX);
