/* $Id: wm.c,v 1.2 2001/05/24 14:53:57 malekith Exp $ */

#include <yw/util.h>
#include <yw/sock.h>
#include <yw/window.h>
#include <yw/unigfx.h>
#include <yw/keys.h>
#include <stdio.h>
#include <stdlib.h>

/*
 * General events for WM.
 * wm_kbd WM_WIN_ID KEY... -> wm_kbd_accepted 0|1 
 * wm_new_window TAGS... -> wm_new_window_accepted TAGS...
 *  outtags: wm_width wm_height wm_offset_x wm_offset_y wm_pos_x wm_pos_y
 * wm_win_id WM_WIN_ID
 * wm_window_closed WM_WIN_ID                                
 */


YwConnection *conn;

void state()
{
	const char *file;
	int line;
	int state;
	
	yw_conn_get_state(conn, &file, &line, &state);
	printf("state = %s [%d], %s:%d\n", yw_strerror(state), 
		state, file, line);
}

void check_state()
{
	if (yw_conn_state(conn)) {
		state();
		exit(1);
	}
}

typedef struct Window_struct Window;
struct Window_struct {
	Window *next;
	int win_id;
	int move_mode;
	int x, y;
	int w, h;
	YwString title;
};

Window *win_head;

/*
 * wm_new_window TAGS... -> wm_new_window_accepted TAGS...
 *  outtags: wm_{width,height} wm_offset_{x,y} wm_pos_{x,y}
 * wm_win_id WM_WIN_ID
 */

void draw_frame(Window *w)
{
	YwString str;
	YwPacket *tmp;
	int i;

	if (w == NULL)
		return;

	yw_conn_queue_and_free(conn, yw_packet_make(yw_void_call_packet,
			"k", "wm_goto",
			"i", w->win_id,
			"i", 0,
			"i", 0,
			YW_END));
	
	yw_conn_queue_and_free(conn, yw_packet_make(yw_void_call_packet,
			"k", "wm_attr",
			"i" "reset", 0,
			YW_END));
			
	yw_conn_queue_and_free(conn, yw_packet_make(yw_void_call_packet,
			"k", "wm_attr",
			"i" "fg", 
				w->move_mode ?
					YW_COLOR_ANSI_LIGHTRED :
				w == win_head ? 
					YW_COLOR_ANSI_LIGHTCYAN :
					YW_COLOR_ANSI_CYAN,
			YW_END));
		
	yw_string_assign_n_chars(&str, 
		w == win_head ? 
			YW_UNIGFX_FILL_3 :
			YW_UNIGFX_BOX_H, 
		w->w);
	
	if (w->title.len <= w->w - 6) {
		memcpy(str.chars + (w->w - w->title.len) / 2,
		       w->title.chars, w->title.len * sizeof(uint32_t));
		str.chars[(w->w - w->title.len) / 2 - 1] = ' ';
		str.chars[(w->w - w->title.len) / 2 + w->title.len] = ' ';
	} else if (w->w > 10) {
		str.chars[2] = ' ';
		memcpy(str.chars + 3, w->title.chars,
		       (w->w - 8) * sizeof(uint32_t));
		str.chars[w->w - 3] = ' ';
		str.chars[w->w - 4] = '.';
		str.chars[w->w - 5] = '.';
		str.chars[w->w - 6] = '.';
		str.chars[w->w - 7] = ' ';
	}

	str.chars[0] = YW_UNIGFX_BOX_D_R;
	str.chars[w->w - 1] = YW_UNIGFX_BOX_D_L;
	
	yw_conn_queue_and_free(conn, yw_packet_make(yw_void_call_packet,
			"k", "wm_print",
			"s", &str,
			YW_END));
	
	str.chars[0] = YW_UNIGFX_BOX_V;
	str.len = 1;
	
	tmp = yw_packet_make(yw_void_call_packet,
			"k", "wm_print",
			"s", &str,
			YW_END);
			
	for (i = 1; i < w->h - 1; i++) {
		yw_conn_queue_and_free(conn, 
			yw_packet_make(yw_void_call_packet,
				"k", "wm_goto",
				"i", w->win_id,
				"i", 0,
				"i", i,
			YW_END));
		yw_conn_queue(conn, tmp);
		yw_conn_queue_and_free(conn, 
			yw_packet_make(yw_void_call_packet,
				"k", "wm_goto",
				"i", w->win_id,
				"i", w->w - 1,
				"i", i,
			YW_END));
		yw_conn_queue(conn, tmp);
	}
	
	yw_packet_free(tmp);

	yw_conn_queue_and_free(conn, 
			yw_packet_make(yw_void_call_packet,
				"k", "wm_goto",
				"i", w->win_id,
				"i", 0,
				"i", i,
			YW_END));
	str.len = w->w;
	i = 0;
	str.chars[i++] = YW_UNIGFX_BOX_U_R;
	while (i < w->w - 1)
		str.chars[i++] = YW_UNIGFX_BOX_H;
	str.chars[i++] = YW_UNIGFX_BOX_U_L;

	yw_conn_queue_and_free(conn, yw_packet_make(yw_void_call_packet,
			"k", "wm_print",
			"s", &str,
			YW_END));
	yw_conn_queue_and_free(conn, yw_packet_make(yw_void_call_packet,
			"k", "wm_flush",
			YW_END));
	yw_conn_queue_flush(conn);
}

void new_window(YwWord *tags)
{
	Window *w;
	YwPacket *pkt;
	static int pos;
	const char *kw;

	w = YW_NEW_0(Window);
	
	if (pos++ > 10)
		pos = 1;
		
	w->x = w->y = pos;
	yw_word_fetch_int(yw_tag_find(tags, "wm_pos_x"), &w->x);
	yw_word_fetch_int(yw_tag_find(tags, "wm_pos_y"), &w->y);

	w->w = 40;
	w->h = 10;
	yw_word_fetch_int(yw_tag_find(tags, "width"), &w->w);
	yw_word_fetch_int(yw_tag_find(tags, "height"), &w->h);

	w->w += 2;
	w->h += 2;
	
	if (yw_tag_find(tags, "wm_title")) {
		YwString *str;
		yw_word_fetch_string(yw_tag_find(tags, "wm_title"), &str);
		yw_string_assign_string(&w->title, str);
	} else {
		yw_string_assign_empty(&w->title);
	}

	yw_conn_send_and_free(conn, yw_packet_make(yw_reply_packet,
				"k", "wm_new_window_accepted",
				"i" "wm_pos_x", w->x,
				"i" "wm_pos_y", w->y,
				"i" "wm_width", w->w,
				"i" "wm_height", w->h,
				"i" "wm_offset_x", 1,
				"i" "wm_offset_y", 1,
				YW_END));
	pkt = yw_conn_recv_reply(conn, -1);

	if (pkt == NULL || 
	    yw_word_fetch_keyword(yw_packet_word(pkt, 0), &kw) ||
	    strcmp(kw, "wm_win_id") != 0 ||
	    yw_word_fetch_int(yw_packet_word(pkt, 1), &w->win_id)) {
		yw_free(w);
		yw_packet_free(pkt);
		return;	/* oops */
	}

	yw_packet_free(pkt);
	w->next = win_head;
	win_head = w;

	draw_frame(w->next);
	draw_frame(w);
}

void kill_window(int winid)
{
	Window *w, *p;

	for (w = win_head; w; w = w->next)
		if (w->win_id == winid)
			break;
	if (w == NULL)
		return;
		
	if (w == win_head)
		win_head = win_head->next;
	else {
		for (p = win_head; p->next != w; p = p->next)
			/* nothing */ ;
		p->next = p->next->next;
	}
	
	yw_free(w);

	if (win_head)
		yw_conn_send_and_free(conn, yw_packet_make(yw_void_call_packet,
			"i" "wm_focus", win_head->win_id,
			YW_END));
	draw_frame(win_head);
}

void cycle_window()
{
	Window *w, *p;

	w = win_head;
	
	win_head = win_head->next;

	for (p = win_head; p; p = p->next)
		if (p->next == NULL)
			break;
			
	if (p == NULL)
		win_head = w;
	else {
		p->next = w;
		draw_frame(w);
		draw_frame(win_head);
	}
	
	w->next = NULL;

	yw_conn_send_and_free(conn, yw_packet_make(yw_void_call_packet,
			"i" "wm_focus", win_head->win_id,
			YW_END));
}

void move_win(int key)
{
	Window *w;

	w = win_head;
	
	switch (key) {
	case yw_key_left:
		w->x--;
		break;
	case yw_key_right:
		w->x++;
		break;
	case yw_key_up:
		w->y--;
		break;
	case yw_key_down:
		w->y++;
		break;
	}

	yw_conn_send_and_free(conn, yw_packet_make(yw_void_call_packet,
			"k", "wm_move", 
			"i", w->win_id,
			"i", w->x,
			"i", w->y,
			YW_END));
}


void kbd(YwPacket *pkt)
{
	int did = 0;
	int key, flags;
	YwString *str;
	
	if (yw_key_special(pkt, &key, &flags) == 0) {
		switch (key) {
		case YW_KEY_F(12):
			if (win_head)
				win_head->move_mode = 0;
			cycle_window();
			did++;
			break;
		case YW_KEY_F(11):
			if (win_head) {
				win_head->move_mode = !win_head->move_mode;
				draw_frame(win_head);
				did++;
			}
			break;
		case YW_KEY_F(10):	/* to be changed to window menu */
			if (win_head) {
				yw_conn_send_and_free(conn, yw_packet_make(yw_void_call_packet,
					"k", "wm_kill", 
					"i", win_head->win_id,
					YW_END));
				did++;
			}
			break;
		case YW_KEY_F(9):
			/* place holder for global menu */
			did++;
			break;
		case yw_key_left:
		case yw_key_right:
		case yw_key_up:
		case yw_key_down:
			if (win_head && win_head->move_mode) {
				move_win(key);
				did++;
			}
			break;
		default:
			if (win_head && win_head->move_mode) {
				win_head->move_mode = 0;
				draw_frame(win_head);
			}
			break;
		}
	} else if (yw_key_normal(pkt, &str, &flags) == 0) {
		switch (str->chars[0]) {
		default:
			if (win_head && win_head->move_mode) {
				win_head->move_mode = 0;
				draw_frame(win_head);
			}
			break;
		}
	}
	
	yw_conn_send_and_free(conn, yw_packet_make(yw_reply_packet,
				"i" "wm_kbd_accepted", did,
				YW_END));
}

char *process_packet(YwPacket *pkt)
{
	enum {
		wm_kbd,	 
		wm_new_window,
		wm_window_closed,
		wm_oops
	};
	static YwMapEntry e[] = {
		{ "wm_kbd", wm_kbd },	 
		{ "wm_new_window", wm_new_window },
		{ "wm_window_closed", wm_window_closed },
		{ NULL, wm_oops }
	};
	static YwMapCache *cache;
	int i;
	
	if (yw_word_fetch_mapped_keyword(
		yw_packet_word(pkt, 0), e, &cache, &i))
		return "bad packet";
	
	switch (i) {
	case wm_kbd:
		kbd(pkt);
		break;
	case wm_new_window:
		if (yw_tag_validate(yw_packet_word(pkt, 1)))
			return "bad wm_new_window taglist";
		new_window(yw_packet_word(pkt, 1));
		break;
	case wm_window_closed:
		if (yw_word_fetch_int(yw_packet_word(pkt, 1), &i))
			return "non-int arg for wm_window_closed";
		kill_window(i);
		break;
	default:
		return "unknown packet";
	}

	return NULL;
}

int main()
{
	YwPacket *pkt;
	
	conn = yw_conn_new();
	yw_conn_open(conn);
	check_state();

	/* tell server, we're Window Manager */
	yw_conn_send_and_free(conn, yw_packet_make(yw_void_call_packet,
			"k" "i_am", "window_manager", YW_END));

	for (;;) {
		pkt = yw_conn_recv(conn, -1);
		check_state();

		if (pkt) {
			const char *oops;
			
			oops = process_packet(pkt);

			if (oops)
				printf("oops: %s\n", oops);
				
			yw_packet_free(pkt);
		}
	}

	return 0;
}
