/* $Id: hello.c,v 1.1 2001/05/04 11:04:19 malekith Exp $ */

#include <yw/util.h>
#include <yw/sock.h>
#include <yw/window.h>
#include <stdio.h>
#include <stdlib.h>

YwConnection *conn;

void state()
{
	const char *file;
	int line;
	int state;
	
	yw_conn_get_state(conn, &file, &line, &state);
	printf("state = %s [%d], %s:%d\n", yw_strerror(state), 
		state, file, line);
}

void check_state()
{
	if (yw_conn_state(conn)) {
		state();
		exit(1);
	}
}

void write_hello(YwBuffer *buf)
{
	YwString hello;

	yw_string_assign_cstring(&hello, NULL, "Hello world!", -1);
	
	yw_buffer_set_bg(buf, YW_COLOR_ANSI_BLUE);
	yw_buffer_set_fg(buf, YW_COLOR_ANSI_WHITE);
	yw_buffer_clr(buf);
	yw_buffer_goto(buf, 1, 1);
	yw_buffer_puts(buf, &hello);
	yw_buffer_sync(buf);
}

int main()
{
	YwWindow *win;
	
	conn = yw_conn_new();
	yw_conn_open(conn);
	check_state();

	win = yw_window_new_and_free(conn, yw_packet_make(yw_taglist_packet,
				"i" "width", 20,
				"i" "height", 5,
				YW_END));
	write_hello(yw_window_buffer(win));
	
	yw_conn_recv(conn, -1);

	return 0;
}
