/* $Id: cli.c,v 1.5 2001/05/04 11:04:19 malekith Exp $ */

#include <yw/util.h>
#include <yw/sock.h>
#include <stdio.h>
#include <stdlib.h>

YwConnection *conn;
int argc;
char **argv;

struct command {
	const char *name;
	void (*run)(void);
};

void state()
{
	const char *file;
	int line;
	int state;
	
	yw_conn_get_state(conn, &file, &line, &state);
	printf("state = %s [%d], %s:%d\n", yw_strerror(state), 
		state, file, line);
}

void check_state()
{
	if (yw_conn_state(conn)) {
		state();
		exit(1);
	}
}

void pkt_dump(YwPacket *pkt)
{
	YwWord *w;
	char *s;
	const char *kw;
	int i;
	void *p;
	YwString *str;
	
	printf("pkt: %c", yw_packet_type(pkt));

	for (w = yw_packet_word(pkt, 0); w; w = yw_word_next(w))
		if (yw_word_fetch_keyword(w, &kw) == 0)
			printf(" '%s'", kw);
		else if (yw_word_fetch_int(w, &i) == 0)
			printf(" %d", i);
		else if (yw_word_fetch_void(w) == 0)
			printf(" [void]");
		else if (yw_word_fetch_ptr(w, &p) == 0)
			printf(" %p", p);
		else if (yw_word_fetch_string(w, &str) == 0) {
			s = NULL;
			yw_string_get_cstring(str, NULL, 
					&s, NULL);
			printf(" \"%s\"", s);
			yw_free(s);
		} else
			printf(" <unknown>");
	printf("\n");
}

void do_ping()
{
	YwPacket *pkt;

	yw_conn_send_and_free(conn, yw_packet_make(yw_call_packet,
		"d" "ping", "Hello there!", YW_END));
	check_state();

	pkt = yw_conn_recv(conn, -1);
	check_state();

	pkt_dump(pkt);
}

void do_dmesg()
{
	YwPacket *pkt;
	YwWord *w;
	YwString *str;
	char *s;

	yw_conn_send_and_free(conn, yw_packet_make(yw_call_packet,
		"i" "dmesg", 4096, YW_END));
	check_state();

	pkt = yw_conn_recv(conn, -1);
	check_state();

	w = yw_packet_word(pkt, 1);
	if (yw_word_fetch_string(w, &str) == 0) {
		s = NULL;
		yw_string_get_cstring(str, NULL, &s, NULL);
		printf("%s\n", s);
	} else
		pkt_dump(pkt);
}

void usage()
{
	fprintf(stderr, 
		"Usage: %s <command>\n"
		"<command> is one of:\n"
		" ping\n"
		" dmesg\n", argv[0]);
	exit(1);
}

struct command cmds[] = {
	{ "ping", do_ping },
	{ "dmesg", do_dmesg },
	{ 0, 0 }
};

int main(int margc, char **margv)
{
	int i;
	
	argc = margc;
	argv = margv;
	
	if (argc < 2) 
		usage();

	for (i = 0; cmds[i].name; i++)
		if (strcmp(cmds[i].name, argv[1]) == 0)
			break;
			
	if (cmds[i].run == NULL)
		usage();
		
	conn = yw_conn_new();
	yw_conn_open(conn);
	check_state();

	cmds[i].run();

	return 0;
}
