#!/usr/bin/perl -w
# $Id: qapprox2table.pl,v 1.1 2001/04/21 12:04:30 malekith Exp $

sub get_one
{
	my $s = shift;
	my $r;
	
	if ($s =~ /^\\x([0-9a-fA-F]+)/) {
		$r = hex $1; 
	} elsif ($s =~ /^\\"/) {
		$r = ord('"');
	} elsif ($s =~ /^\\0/) {
		$r = 0;
	} elsif ($s =~ /^\\&/) {
		return undef;
	} else {
		$r = ord($s);
	}

	return $r;
}


for ($i=0; $i<256; $i++) {
$content[$i] = "";
$idx[$i] = "";
$pos[$i] = 0;
$nn[$i] = 0;
}

$state = 1;

while (<STDIN>) {
	chomp;
	if ($state == 3 or !/^\s*\('([^']+)',\s*\[(("(\\"|[^"])*",?\s*)*)\]\)[,\]]$/) {
		$state = 3 if ($state == 2);
		print "/* $_ */\n";
		next;
	}
	$state = 2;

	$ch = $1;
	$a = $2;


	$ch = get_one($ch);
	$i = ($ch & 0xff) ^ ($ch / 256);
	$idx[$i] .= sprintf("0x%04x, %d, ", $ch, $pos[$i]);
	$nn[$i]++;
	
	while ($a =~ s/"((\\"|[^"])*)",?\s*//) {
		$f = $1;
		$n = 0;
		$f2 = $f;
		$content[$i] .= sprintf "/* 0x%04x -> \"%s\" */ ", $ch, $f;
		while ($f =~ s/^(\\[0"&]|\\x[0-9a-fA-F]+|.)//) {
			$n++ unless ($1 eq "\\&");
		}
		$f = $f2;
		$content[$i] .= "$n, ";
		$pos[$i]++;
		while ($f =~ s/^(\\[0"&]|\\x[0-9a-fA-F]+|.)//) {
			$r = get_one($1);
			if (defined $r) {
				$content[$i] .= sprintf("0x%04x, ", $r);
				$pos[$i]++;
			}
		}
		$content[$i] .= "0,\n";
		$pos[$i]++;
	}
}

$max_nn = 0;

for ($i=0; $i<256; $i++) {
$max_nn = $nn[$i] if ($nn[$i] > $max_nn);
$nn[$i] *= 2;
print <<EOF
static uint16_t xxx_$i\[] = { $nn[$i],
$idx[$i]
/* ---> */
$content[$i]};

EOF
}

$fallback = "fallback" unless (defined ($fallback = shift));

print "uint16_t *$fallback\[256] = {\n";

for ($i=0; $i<256; $i++) {
print "\txxx_$i,\n";
}

print "};\n/* max_nn = $max_nn */\n/* EOF */\n";

