module QApprox (
    generic, bulgarian, croatian, german, ukrainian, vietnamese)
        -- :: FiniteMap Char [String]
    where

import FiniteMap

generic :: FiniteMap Char [String]
generic = listToFM [
    ('\xA0',   [" "]),
    ('\xA1',   ["!"]),
    ('\xA2',   ["c"]),
    ('\xA3',   ["L"]),
    ('\xA4',   ["CUR",      "*"]),
    ('\xA5',   ["Y"]),
    ('\xA6',   ["|"]),
    ('\xA7',   ["S:",       "S"]),
    ('\xA8',   ["\""]),
    ('\xA9',   ["(c)",      "c"]),
    ('\xAA',   ["-a",       "a"]),
    ('\xAB',   ["<<",       "<"]),
    ('\xAC',   ["~"]),
    ('\xAD',   ["&",        "-"]),
    ('\xAE',   ["(R)",      "R"]),
    ('\xAF',   ["-"]),
    ('\xB0',   ["\x2DA",    "o"]),
    ('\xB1',   ["+-"]),
    ('\xB2',   ["^2",       "2"]),
    ('\xB3',   ["^3",       "3"]),
    ('\xB4',   ["'"]),
    ('\xB5',   ["\x3BC",    "u"]),
    ('\xB6',   ["P:",       "P"]),
    ('\xB7',   ["\x2022",   "\x2219",   "."]),
    ('\xB8',   [","]),
    ('\xB9',   ["^1",       "1"]),
    ('\xBA',   ["-o",       "o"]),
    ('\xBB',   [">>",       ">"]),
    ('\xBC',   [" 1/4",     "/"]),
    ('\xBD',   [" 1/2",     "/"]),
    ('\xBE',   [" 3/4",     "/"]),
    ('\xBF',   ["?"]),
    ('\xC0',   ["A"]),
    ('\xC1',   ["A"]),
    ('\xC2',   ["A"]),
    ('\xC3',   ["A"]),
    ('\xC4',   ["A"]),
    ('\xC5',   ["AA",       "A"]),
    ('\xC6',   ["AE",       "A"]),
    ('\xC7',   ["C"]),
    ('\xC8',   ["E"]),
    ('\xC9',   ["E"]),
    ('\xCA',   ["E"]),
    ('\xCB',   ["E"]),
    ('\xCC',   ["I"]),
    ('\xCD',   ["I"]),
    ('\xCE',   ["I"]),
    ('\xCF',   ["I"]),
    ('\xD0',   ["\x110",    "DH",       "D"]),
    ('\xD1',   ["N"]),
    ('\xD2',   ["O"]),
    ('\xD3',   ["O"]),
    ('\xD4',   ["O"]),
    ('\xD5',   ["O"]),
    ('\xD6',   ["O"]),
    ('\xD7',   ["x"]),
    ('\xD8',   ["O"]),
    ('\xD9',   ["U"]),
    ('\xDA',   ["U"]),
    ('\xDB',   ["U"]),
    ('\xDC',   ["U"]),
    ('\xDD',   ["Y"]),
    ('\xDE',   ["TH",       "T"]),
    ('\xDF',   ["ss",       "s"]),
    ('\xE0',   ["a"]),
    ('\xE1',   ["a"]),
    ('\xE2',   ["a"]),
    ('\xE3',   ["a"]),
    ('\xE4',   ["a"]),
    ('\xE5',   ["aa",       "a"]),
    ('\xE6',   ["ae",       "a"]),
    ('\xE7',   ["c"]),
    ('\xE8',   ["e"]),
    ('\xE9',   ["e"]),
    ('\xEA',   ["e"]),
    ('\xEB',   ["e"]),
    ('\xEC',   ["i"]),
    ('\xED',   ["i"]),
    ('\xEE',   ["i"]),
    ('\xEF',   ["i"]),
    ('\xF0',   ["dh",       "d"]),
    ('\xF1',   ["n"]),
    ('\xF2',   ["o"]),
    ('\xF3',   ["o"]),
    ('\xF4',   ["o"]),
    ('\xF5',   ["o"]),
    ('\xF6',   ["o"]),
    ('\xF7',   [":"]),
    ('\xF8',   ["o"]),
    ('\xF9',   ["u"]),
    ('\xFA',   ["u"]),
    ('\xFB',   ["u"]),
    ('\xFC',   ["u"]),
    ('\xFD',   ["y"]),
    ('\xFE',   ["th",       "t"]),
    ('\xFF',   ["y"]),
    ('\x100',  ["A"]),
    ('\x101',  ["a"]),
    ('\x102',  ["A"]),
    ('\x103',  ["a"]),
    ('\x104',  ["A"]),
    ('\x105',  ["a"]),
    ('\x106',  ["C"]),
    ('\x107',  ["c"]),
    ('\x108',  ["CX",       "C"]),
    ('\x109',  ["cx",       "c"]),
    ('\x10A',  ["C"]),
    ('\x10B',  ["c"]),
    ('\x10C',  ["C"]),
    ('\x10D',  ["c"]),
    ('\x10E',  ["D"]),
    ('\x10F',  ["d"]),
    ('\x110',  ["\xD0",     "D"]),
    ('\x111',  ["d"]),
    ('\x112',  ["E"]),
    ('\x113',  ["e"]),
    ('\x114',  ["E"]),
    ('\x115',  ["e"]),
    ('\x116',  ["E"]),
    ('\x117',  ["e"]),
    ('\x118',  ["E"]),
    ('\x119',  ["e"]),
    ('\x11A',  ["E"]),
    ('\x11B',  ["e"]),
    ('\x11C',  ["GX",       "G"]),
    ('\x11D',  ["gx",       "g"]),
    ('\x11E',  ["G"]),
    ('\x11F',  ["g"]),
    ('\x120',  ["G"]),
    ('\x121',  ["g"]),
    ('\x122',  ["G"]),
    ('\x123',  ["g"]),
    ('\x124',  ["HX",       "H"]),
    ('\x125',  ["hx",       "h"]),
    ('\x126',  ["H"]),
    ('\x127',  ["H"]),
    ('\x128',  ["I"]),
    ('\x129',  ["i"]),
    ('\x12A',  ["I"]),
    ('\x12B',  ["i"]),
    ('\x12C',  ["I"]),
    ('\x12D',  ["i"]),
    ('\x12E',  ["I"]),
    ('\x12F',  ["i"]),
    ('\x130',  ["I"]),
    ('\x131',  ["i"]),
    ('\x132',  ["IJ",       "\x178",    "Y"]),
    ('\x133',  ["ij",       "\xFF",     "y"]),
    ('\x134',  ["JX",       "J"]),
    ('\x135',  ["jx",       "j"]),
    ('\x136',  ["K"]),
    ('\x137',  ["k"]),
    ('\x138',  ["k"]),
    ('\x139',  ["L"]),
    ('\x13A',  ["l"]),
    ('\x13B',  ["L"]),
    ('\x13C',  ["l"]),
    ('\x13D',  ["L"]),
    ('\x13E',  ["l"]),
    ('\x13F',  ["L"]),
    ('\x140',  ["l"]),
    ('\x141',  ["L"]),
    ('\x142',  ["l"]),
    ('\x143',  ["N"]),
    ('\x144',  ["n"]),
    ('\x145',  ["N"]),
    ('\x146',  ["n"]),
    ('\x147',  ["N"]),
    ('\x148',  ["n"]),
    ('\x149',  ["\x2019n",  "'n",       "n"]),
    ('\x14A',  ["N"]),
    ('\x14B',  ["N"]),
    ('\x14C',  ["O"]),
    ('\x14D',  ["o"]),
    ('\x14E',  ["O"]),
    ('\x14F',  ["o"]),
    ('\x150',  ["O"]),
    ('\x151',  ["o"]),
    ('\x152',  ["OE",       "O"]),
    ('\x153',  ["oe",       "o"]),
    ('\x154',  ["R"]),
    ('\x155',  ["r"]),
    ('\x156',  ["R"]),
    ('\x157',  ["r"]),
    ('\x158',  ["R"]),
    ('\x159',  ["r"]),
    ('\x15A',  ["S"]),
    ('\x15B',  ["s"]),
    ('\x15C',  ["SX",       "S"]),
    ('\x15D',  ["sx",       "s"]),
    ('\x15E',  ["S"]),
    ('\x15F',  ["s"]),
    ('\x160',  ["S"]),
    ('\x161',  ["s"]),
    ('\x162',  ["T"]),
    ('\x163',  ["t"]),
    ('\x164',  ["T"]),
    ('\x165',  ["t"]),
    ('\x166',  ["T"]),
    ('\x167',  ["t"]),
    ('\x168',  ["U"]),
    ('\x169',  ["u"]),
    ('\x16A',  ["U"]),
    ('\x16B',  ["u"]),
    ('\x16C',  ["UX",       "U"]),
    ('\x16D',  ["ux",       "u"]),
    ('\x16E',  ["U"]),
    ('\x16F',  ["u"]),
    ('\x170',  ["U"]),
    ('\x171',  ["u"]),
    ('\x172',  ["U"]),
    ('\x173',  ["u"]),
    ('\x174',  ["W"]),
    ('\x175',  ["w"]),
    ('\x176',  ["Y"]),
    ('\x177',  ["y"]),
    ('\x178',  ["Y"]),
    ('\x179',  ["Z"]),
    ('\x17A',  ["z"]),
    ('\x17B',  ["Z"]),
    ('\x17C',  ["z"]),
    ('\x17D',  ["Z"]),
    ('\x17E',  ["z"]),
    ('\x17F',  ["s1",       "s"]),
    ('\x187',  ["C2",       "C"]),
    ('\x188',  ["c2",       "c"]),
    ('\x191',  ["F2",       "F"]),
    ('\x192',  ["f"]),
    ('\x198',  ["K2",       "K"]),
    ('\x199',  ["k2",       "k"]),
    ('\x1A0',  ["O+",       "O"]),
    ('\x1A1',  ["o+",       "o"]),
    ('\x1A2',  ["OI",       "O"]),
    ('\x1A3',  ["oi",       "o"]),
    ('\x1A6',  ["yr"]),
    ('\x1AF',  ["U+",       "U"]),
    ('\x1B0',  ["u+",       "u"]),
    ('\x1B5',  ["Z/",       "Z"]),
    ('\x1B6',  ["z/",       "z"]),
    ('\x1B7',  ["ED",       "Z"]),
    ('\x1C4',  ["D\x17D",   "DZ",       "D"]),
    ('\x1C5',  ["D\x17E",   "Dz",       "D"]),
    ('\x1C6',  ["d\x17E",   "dz",       "d"]),
    ('\x1C7',  ["LJ",       "L"]),
    ('\x1C8',  ["Lj",       "L"]),
    ('\x1C9',  ["lj",       "l"]),
    ('\x1CA',  ["NJ",       "N"]),
    ('\x1CB',  ["Nj",       "N"]),
    ('\x1CC',  ["nj",       "n"]),
    ('\x1CD',  ["A"]),
    ('\x1CE',  ["a"]),
    ('\x1CF',  ["I"]),
    ('\x1D0',  ["i"]),
    ('\x1D1',  ["O"]),
    ('\x1D2',  ["o"]),
    ('\x1D3',  ["U"]),
    ('\x1D4',  ["u"]),
    ('\x1D5',  ["\xDC",     "U"]),
    ('\x1D6',  ["\xFC",     "u"]),
    ('\x1D7',  ["\xDC",     "U"]),
    ('\x1D8',  ["\xFC",     "u"]),
    ('\x1D9',  ["\xDC",     "U"]),
    ('\x1DA',  ["\xFC",     "u"]),
    ('\x1DB',  ["\xDC",     "U"]),
    ('\x1DC',  ["\xFC",     "u"]),
    ('\x1DE',  ["\xC4",     "A"]),
    ('\x1DF',  ["\xE4",     "a"]),
    ('\x1E0',  ["A"]),
    ('\x1E1',  ["a"]),
    ('\x1E2',  ["\xC6",     "\x100\&E", "AE",       "\x100",    "A"]),
    ('\x1E3',  ["\xE6",     "\x101\&e", "ae",       "\x101",    "a"]),
    ('\x1E4',  ["G"]),
    ('\x1E5',  ["g"]),
    ('\x1E6',  ["G"]),
    ('\x1E7',  ["g"]),
    ('\x1E8',  ["K"]),
    ('\x1E9',  ["k"]),
    ('\x1EA',  ["O"]),
    ('\x1EB',  ["o"]),
    ('\x1EC',  ["\x1EA",    "O"]),
    ('\x1ED',  ["\x1EB",    "o"]),
    ('\x1EE',  ["EZ",       "\x17D",    "Z"]),
    ('\x1EF',  ["ez",       "\x17E",    "z"]),
    ('\x1F0',  ["j"]),
    ('\x1F1',  ["DZ",       "D"]),
    ('\x1F2',  ["Dz",       "D"]),
    ('\x1F3',  ["dz",       "d"]),
    ('\x1F4',  ["G"]),
    ('\x1F5',  ["g"]),
    ('\x1FA',  ["\xC5",     "\xC1\&A",  "AA",       "\xC1",     "A"]),
    ('\x1FB',  ["\xE5",     "\xE1\&a",  "aa",       "\xE1",     "a"]),
    ('\x1FC',  ["\xC6",     "\xC1\&E",  "AE",       "\xC1",     "A"]),
    ('\x1FD',  ["\xE6",     "\xE1\&e",  "ae",       "\xE1",     "a"]),
    ('\x1FE',  ["\xD8",     "\xD3",     "O"]),
    ('\x1FF',  ["\xF8",     "\xF3",     "o"]),
    ('\x200',  ["A"]),
    ('\x201',  ["a"]),
    ('\x202',  ["A"]),
    ('\x203',  ["a"]),
    ('\x204',  ["E"]),
    ('\x205',  ["e"]),
    ('\x206',  ["E"]),
    ('\x207',  ["e"]),
    ('\x208',  ["I"]),
    ('\x209',  ["i"]),
    ('\x20A',  ["I"]),
    ('\x20B',  ["i"]),
    ('\x20C',  ["O"]),
    ('\x20D',  ["o"]),
    ('\x20E',  ["O"]),
    ('\x20F',  ["o"]),
    ('\x210',  ["R"]),
    ('\x211',  ["r"]),
    ('\x212',  ["R"]),
    ('\x213',  ["r"]),
    ('\x214',  ["U"]),
    ('\x215',  ["u"]),
    ('\x216',  ["U"]),
    ('\x217',  ["u"]),
    ('\x251',  ["A"]),
    ('\x252',  ["A."]),
    ('\x253',  ["b`"]),
    ('\x254',  ["O"]),
    ('\x256',  ["d."]),
    ('\x257',  ["d`"]),
    ('\x258',  ["@<umd>"]),
    ('\x259',  ["@"]),
    ('\x25A',  ["R"]),
    ('\x25B',  ["E"]),
    ('\x25C',  ["V\""]),
    ('\x25D',  ["R<umd>"]),
    ('\x25E',  ["O\""]),
    ('\x25F',  ["J"]),
    ('\x260',  ["g`"]),
    ('\x261',  ["g"]),
    ('\x262',  ["G"]),
    ('\x263',  ["Q"]),
    ('\x264',  ["o-"]),
    ('\x265',  ["j<rnd>"]),
    ('\x266',  ["h<?>"]),
    ('\x268',  ["i\""]),
    ('\x269',  ["I"]),
    ('\x26A',  ["I"]),
    ('\x26B',  ["L"]),
    ('\x26C',  ["L"]),
    ('\x26D',  ["l."]),
    ('\x26E',  ["z<lat>"]),
    ('\x26F',  ["u-"]),
    ('\x270',  ["j<vel>"]),
    ('\x271',  ["M"]),
    ('\x273',  ["n."]),
    ('\x274',  ["n\""]),
    ('\x275',  ["@."]),
    ('\x276',  ["&."]),
    ('\x277',  ["U"]),
    ('\x279',  ["r"]),
    ('\x27A',  ["*<lat>"]),
    ('\x27B',  ["r."]),
    ('\x27C',  ["r"]),
    ('\x27D',  ["*."]),
    ('\x27E',  ["*"]),
    ('\x280',  ["R"]),
    ('\x280',  ["r\""]),
    ('\x281',  ["g\""]),
    ('\x282',  ["s."]),
    ('\x283',  ["S"]),
    ('\x284',  ["J`"]),
    ('\x287',  ["t!"]),
    ('\x288',  ["t."]),
    ('\x289',  ["u\""]),
    ('\x28A',  ["U"]),
    ('\x28B',  ["r<lbd>"]),
    ('\x28C',  ["V"]),
    ('\x28D',  ["w<vls>"]),
    ('\x28E',  ["l^"]),
    ('\x28F',  ["I."]),
    ('\x290',  ["z."]),
    ('\x292',  ["ed",  "z"]),
    ('\x294',  ["?"]),
    ('\x295',  ["H<vcd>"]),
    ('\x296',  ["l!"]),
    ('\x297',  ["c!"]),
    ('\x298',  ["p!"]),
    ('\x299',  ["b<trl>"]),
    ('\x29B',  ["G`"]),
    ('\x29D',  ["j"]),
    ('\x29E',  ["k!"]),
    ('\x29F',  ["L"]),
    ('\x2A0',  ["q`"]),
    ('\x2B0',  ["<h>"]),
    ('\x2B1',  ["<?>"]),
    ('\x2B2',  [";"]),
    ('\x2B3',  ["<r>"]),
    ('\x2B7',  ["<w>"]),
    ('\x2BB',  ["`"]),
    ('\x2C6',  ["^"]),
    ('\x2C7',  ["^"]),
    ('\x2C9',  ["-"]),
    ('\x2CB',  ["`"]),
    ('\x2D8',  ["~"]),
    ('\x2D9',  ["."]),
    ('\x2DA',  ["\xB0",     "*"]),
    ('\x2DB',  [","]),
    ('\x2DC',  ["~"]),
    ('\x2DD',  ["\""]),
    ('\x324',  ["<?>"]),
    ('\x325',  ["<o>"]),
    ('\x32B',  ["<w>"]),
    ('\x334',  ["<H>"]),
    ('\x374',  ["'"]),
    ('\x375',  [","]),
    ('\x37A',  [","]),
    ('\x37E',  [";"]),
    ('\x384',  ["'"]),
    ('\x385',  ["\""]),
    ('\x386',  ["A"]),
    ('\x387',  ["\xB7",     "\x2022",   "\x2219",   "."]),
    ('\x388',  ["E"]),
    ('\x389',  ["\x112",    "EH",       "E"]),
    ('\x38A',  ["I"]),
    ('\x38C',  ["O"]),
    ('\x38E',  ["U"]),
    ('\x38F',  ["\x14C",    "OH",       "O"]),
    ('\x390',  ["i"]),
    ('\x391',  ["A"]),
    ('\x392',  ["B"]),
    ('\x393',  ["G"]),
    ('\x394',  ["D"]),
    ('\x395',  ["E"]),
    ('\x396',  ["Z"]),
    ('\x397',  ["\x112",    "EH",       "E"]),
    ('\x398',  ["TH",       "T"]),
    ('\x399',  ["I"]),
    ('\x39A',  ["K"]),
    ('\x39B',  ["L"]),
    ('\x39C',  ["M"]),
    ('\x39D',  ["N"]),
    ('\x39E',  ["X"]),
    ('\x39F',  ["O"]),
    ('\x3A0',  ["P"]),
    ('\x3A1',  ["R"]),
    ('\x3A3',  ["S"]),
    ('\x3A4',  ["T"]),
    ('\x3A5',  ["U"]),
    ('\x3A6',  ["PH",       "F"]),
    ('\x3A7',  ["CH",       "X"]),
    ('\x3A8',  ["PS",       "P"]),
    ('\x3A9',  ["\x14C",    "OH",       "O"]),
    ('\x3AA',  ["I"]),
    ('\x3AB',  ["U"]),
    ('\x3AC',  ["a"]),
    ('\x3AD',  ["e"]),
    ('\x3AE',  ["\x113",    "eh",       "e"]),
    ('\x3AF',  ["i"]),
    ('\x3B0',  ["u"]),
    ('\x3B1',  ["a"]),
    ('\x3B2',  ["b"]),
    ('\x3B3',  ["g"]),
    ('\x3B4',  ["d"]),
    ('\x3B5',  ["e"]),
    ('\x3B6',  ["z"]),
    ('\x3B7',  ["\x113",    "eh",       "e"]),
    ('\x3B8',  ["th",       "t"]),
    ('\x3B9',  ["i"]),
    ('\x3BA',  ["k"]),
    ('\x3BB',  ["l"]),
    ('\x3BC',  ["m"]),
    ('\x3BD',  ["n"]),
    ('\x3BE',  ["x"]),
    ('\x3BF',  ["o"]),
    ('\x3C0',  ["p"]),
    ('\x3C1',  ["r"]),
    ('\x3C2',  ["s"]),
    ('\x3C3',  ["s"]),
    ('\x3C4',  ["t"]),
    ('\x3C5',  ["u"]),
    ('\x3C6',  ["ph",       "f"]),
    ('\x3C7',  ["ch",       "x"]),
    ('\x3C8',  ["ps",       "p"]),
    ('\x3C9',  ["\x14D",    "oh",       "o"]),
    ('\x3CA',  ["i"]),
    ('\x3CB',  ["u"]),
    ('\x3CC',  ["o"]),
    ('\x3CD',  ["u"]),
    ('\x3CE',  ["\x14D",    "oh",       "o"]),
    ('\x3D0',  ["\x3B2",    "beta",     "b"]),
    ('\x3D1',  ["\x3B8",    "theta",    "t"]),
    ('\x3D2',  ["\x3C5",    "upsi",     "u"]),
    ('\x3D5',  ["\x3C6",    "phi",      "f"]),
    ('\x3D6',  ["\x3C0",    "pi",       "p"]),
    ('\x3F0',  ["\x3BA",    "kappa",    "k"]),
    ('\x3F1',  ["\x3C1",    "rho",      "r"]),
    ('\x401',  ["\x415",    "\xCB",     "E"]),
    ('\x402',  ["DJ",       "\x110",    "D"]),
    ('\x403',  ["\x413",    "\x1F4",    "GJ",       "G"]),
    ('\x404',  ["\x415",    "\x112",    "YE",       "E"]),
    ('\x405',  ["S\0\x410", "DS"]),
    ('\x406',  ["I"]),
    ('\x407',  ["\xCF",     "I"]),
    ('\x408',  ["J"]),
    ('\x409',  ["\x41B\x42C", "LJ",     "\x41B",    "L"]),
    ('\x40A',  ["\x41D\x42C", "NJ",     "\x41D",    "N"]),
    ('\x40B',  ["\x106",    "TSH",      "C"]),
    ('\x40C',  ["\x41A",    "\x1E30",   "KJ",       "K"]),
    ('\x40E',  ["\x423",    "\x16C",    "U"]),
    ('\x40F',  ["DZ"]),
    ('\x410',  ["A"]),
    ('\x411',  ["B"]),
    ('\x412',  ["V"]),
    ('\x413',  ["G"]),
    ('\x414',  ["D"]),
    ('\x415',  ["E"]),
    ('\x416',  ["ZH",       "\x17D",    "Z"]),
    ('\x417',  ["Z"]),
    ('\x418',  ["I"]),
    ('\x419',  ["J"]),
    ('\x41A',  ["K"]),
    ('\x41B',  ["L"]),
    ('\x41C',  ["M"]),
    ('\x41D',  ["N"]),
    ('\x41E',  ["O"]),
    ('\x41F',  ["P"]),
    ('\x420',  ["R"]),
    ('\x421',  ["S"]),
    ('\x422',  ["T"]),
    ('\x423',  ["U"]),
    ('\x424',  ["F"]),
    ('\x425',  ["KH",       "H"]),
    ('\x426',  ["TS",       "C"]),
    ('\x427',  ["CH",       "\x10C",    "C"]),
    ('\x428',  ["SH",       "\x160",    "S"]),
    ('\x429',  ["SHCH",     "\x15C",    "\x160",    "S"]),
    ('\x42A',  ["\""]),
    ('\x42B',  ["Y"]),
    ('\x42C',  ["'"]),
    ('\x42D',  ["\xC8",     "E"]),
    ('\x42E',  ["YU",       "\xDB",     "U"]),
    ('\x42F',  ["YA",       "\xC2",     "A"]),
    ('\x430',  ["a"]),
    ('\x431',  ["b"]),
    ('\x432',  ["v"]),
    ('\x433',  ["g"]),
    ('\x434',  ["d"]),
    ('\x435',  ["e"]),
    ('\x436',  ["zh",       "\x17E",    "z"]),
    ('\x437',  ["z"]),
    ('\x438',  ["i"]),
    ('\x439',  ["j"]),
    ('\x43A',  ["k"]),
    ('\x43B',  ["l"]),
    ('\x43C',  ["m"]),
    ('\x43D',  ["n"]),
    ('\x43E',  ["o"]),
    ('\x43F',  ["p"]),
    ('\x440',  ["r"]),
    ('\x441',  ["s"]),
    ('\x442',  ["t"]),
    ('\x443',  ["u"]),
    ('\x444',  ["f"]),
    ('\x445',  ["kh",       "h"]),
    ('\x446',  ["ts",       "c"]),
    ('\x447',  ["ch",       "\x10D",    "c"]),
    ('\x448',  ["sh",       "\x161",    "s"]),
    ('\x449',  ["shch",     "\x15D",    "\x161",    "s"]),
    ('\x44A',  ["\""]),
    ('\x44B',  ["y"]),
    ('\x44C',  ["'"]),
    ('\x44D',  ["\xE8",     "e"]),
    ('\x44E',  ["yu",       "\xFB",     "u"]),
    ('\x44F',  ["ya",       "\xE2",     "a"]),
    ('\x451',  ["\x435",    "\xEB",     "e"]),
    ('\x452',  ["dj",       "\x111",    "d"]),
    ('\x453',  ["\x433",    "\x1F5",    "gj",       "g"]),
    ('\x454',  ["\x435",    "\x113",    "ye",       "e"]),
    ('\x455',  ["s\0\x430", "ds"]),
    ('\x456',  ["i"]),
    ('\x457',  ["\xEF",     "i"]),
    ('\x458',  ["j"]),
    ('\x459',  ["\x43B\x44C", "lj",     "\x43B",    "l"]),
    ('\x45A',  ["\x43D\x44C", "nj",     "\x43D",    "b"]),
    ('\x45B',  ["\x107",    "tsh",      "c"]),
    ('\x45C',  ["\x43A",    "\x1E31",   "kj",       "k"]),
    ('\x45E',  ["\x443",    "\x16D",    "u"]),
    ('\x45F',  ["dz"]),
    ('\x490',  ["\x413",    "G"]),
    ('\x491',  ["\x433",    "g"]),
    ('\x1E00', ["A"]),
    ('\x1E01', ["a"]),
    ('\x1E02', ["B"]),
    ('\x1E03', ["b"]),
    ('\x1E04', ["B"]),
    ('\x1E05', ["b"]),
    ('\x1E06', ["B"]),
    ('\x1E07', ["b"]),
    ('\x1E08', ["C"]),
    ('\x1E09', ["c"]),
    ('\x1E0A', ["D"]),
    ('\x1E0B', ["d"]),
    ('\x1E0C', ["D"]),
    ('\x1E0D', ["d"]),
    ('\x1E0E', ["D"]),
    ('\x1E0F', ["d"]),
    ('\x1E10', ["D"]),
    ('\x1E11', ["d"]),
    ('\x1E12', ["D"]),
    ('\x1E13', ["d"]),
    ('\x1E14', ["\x112",    "E"]),
    ('\x1E15', ["\x113",    "e"]),
    ('\x1E16', ["\x112",    "E"]),
    ('\x1E17', ["\x113",    "e"]),
    ('\x1E18', ["E"]),
    ('\x1E19', ["e"]),
    ('\x1E1A', ["E"]),
    ('\x1E1B', ["e"]),
    ('\x1E1C', ["E"]),
    ('\x1E1D', ["e"]),
    ('\x1E1E', ["F"]),
    ('\x1E1F', ["f"]),
    ('\x1E20', ["G"]),
    ('\x1E21', ["g"]),
    ('\x1E22', ["H"]),
    ('\x1E23', ["h"]),
    ('\x1E24', ["H"]),
    ('\x1E25', ["h"]),
    ('\x1E26', ["H"]),
    ('\x1E27', ["h"]),
    ('\x1E28', ["H"]),
    ('\x1E29', ["h"]),
    ('\x1E2A', ["H"]),
    ('\x1E2B', ["h"]),
    ('\x1E2C', ["I"]),
    ('\x1E2D', ["i"]),
    ('\x1E2E', ["\xCF",     "I"]),
    ('\x1E2F', ["\xEF",     "i"]),
    ('\x1E30', ["K"]),
    ('\x1E31', ["k"]),
    ('\x1E32', ["K"]),
    ('\x1E33', ["k"]),
    ('\x1E34', ["K"]),
    ('\x1E35', ["k"]),
    ('\x1E36', ["L"]),
    ('\x1E37', ["l"]),
    ('\x1E38', ["L"]),
    ('\x1E39', ["l"]),
    ('\x1E3A', ["L"]),
    ('\x1E3B', ["l"]),
    ('\x1E3C', ["L"]),
    ('\x1E3D', ["l"]),
    ('\x1E3E', ["M"]),
    ('\x1E3F', ["m"]),
    ('\x1E40', ["M"]),
    ('\x1E41', ["m"]),
    ('\x1E42', ["M"]),
    ('\x1E43', ["m"]),
    ('\x1E44', ["N"]),
    ('\x1E45', ["n"]),
    ('\x1E46', ["N"]),
    ('\x1E47', ["n"]),
    ('\x1E48', ["N"]),
    ('\x1E49', ["n"]),
    ('\x1E4A', ["N"]),
    ('\x1E4B', ["n"]),
    ('\x1E4C', ["\xD5",     "O"]),
    ('\x1E4D', ["\xF5",     "o"]),
    ('\x1E4E', ["\xD5",     "O"]),
    ('\x1E4F', ["\xF5",     "o"]),
    ('\x1E50', ["\x14C",    "O"]),
    ('\x1E51', ["\x14D",    "o"]),
    ('\x1E52', ["\x14C",    "O"]),
    ('\x1E53', ["\x14D",    "o"]),
    ('\x1E54', ["P"]),
    ('\x1E55', ["p"]),
    ('\x1E56', ["P"]),
    ('\x1E57', ["p"]),
    ('\x1E58', ["R"]),
    ('\x1E59', ["r"]),
    ('\x1E5A', ["R"]),
    ('\x1E5B', ["r"]),
    ('\x1E5C', ["R"]),
    ('\x1E5D', ["r"]),
    ('\x1E5E', ["R"]),
    ('\x1E5F', ["r"]),
    ('\x1E60', ["S"]),
    ('\x1E61', ["s"]),
    ('\x1E62', ["S"]),
    ('\x1E63', ["s"]),
    ('\x1E64', ["S"]),
    ('\x1E65', ["s"]),
    ('\x1E66', ["S"]),
    ('\x1E67', ["s"]),
    ('\x1E68', ["S"]),
    ('\x1E69', ["s"]),
    ('\x1E6A', ["T"]),
    ('\x1E6B', ["t"]),
    ('\x1E6C', ["T"]),
    ('\x1E6D', ["t"]),
    ('\x1E6E', ["T"]),
    ('\x1E6F', ["t"]),
    ('\x1E70', ["T"]),
    ('\x1E71', ["t"]),
    ('\x1E72', ["U"]),
    ('\x1E73', ["u"]),
    ('\x1E74', ["U"]),
    ('\x1E75', ["u"]),
    ('\x1E76', ["U"]),
    ('\x1E77', ["u"]),
    ('\x1E78', ["\x168",    "U"]),
    ('\x1E79', ["\x169",    "u"]),
    ('\x1E7A', ["\x16A",    "U"]),
    ('\x1E7B', ["\x16B",    "u"]),
    ('\x1E7C', ["V"]),
    ('\x1E7D', ["v"]),
    ('\x1E7E', ["V"]),
    ('\x1E7F', ["v"]),
    ('\x1E80', ["W"]),
    ('\x1E81', ["w"]),
    ('\x1E82', ["W"]),
    ('\x1E83', ["w"]),
    ('\x1E84', ["W"]),
    ('\x1E85', ["w"]),
    ('\x1E86', ["W"]),
    ('\x1E87', ["w"]),
    ('\x1E88', ["W"]),
    ('\x1E89', ["w"]),
    ('\x1E8A', ["X"]),
    ('\x1E8B', ["x"]),
    ('\x1E8C', ["X"]),
    ('\x1E8D', ["x"]),
    ('\x1E8E', ["Y"]),
    ('\x1E8F', ["y"]),
    ('\x1E90', ["Z"]),
    ('\x1E91', ["z"]),
    ('\x1E92', ["Z"]),
    ('\x1E93', ["z"]),
    ('\x1E94', ["Z"]),
    ('\x1E95', ["z"]),
    ('\x1E96', ["h"]),
    ('\x1E97', ["t"]),
    ('\x1E98', ["w"]),
    ('\x1E99', ["y"]),
    ('\x1E9A', ["a"]),
    ('\x1E9B', ["\x17F",    "S"]),
    ('\x1EA0', ["A.",       "A"]),
    ('\x1EA1', ["a.",       "a"]),
    ('\x1EA2', ["A?",       "A"]),
    ('\x1EA3', ["a?",       "a"]),
    ('\x1EA4', ["A^'",      "\xC2",     "A"]),
    ('\x1EA5', ["a^'",      "\xE2",     "a"]),
    ('\x1EA6', ["A^`",      "\xC2",     "A"]),
    ('\x1EA7', ["a^`",      "\xE2",     "a"]),
    ('\x1EA8', ["A^?",      "\xC2",     "A"]),
    ('\x1EA9', ["a^?",      "\xE2",     "a"]),
    ('\x1EAA', ["A^~",      "\xC2",     "A"]),
    ('\x1EAB', ["a^~",      "\xE2",     "a"]),
    ('\x1EAC', ["A^.",      "\xC2",     "A"]),
    ('\x1EAD', ["a^.",      "\xE2",     "a"]),
    ('\x1EAE', ["A('",      "\x102",    "A"]),
    ('\x1EAF', ["a('",      "\x103",    "a"]),
    ('\x1EB0', ["A(`",      "\x102",    "A"]),
    ('\x1EB1', ["a(`",      "\x103",    "a"]),
    ('\x1EB2', ["A(?",      "\x102",    "A"]),
    ('\x1EB3', ["a(?",      "\x103",    "a"]),
    ('\x1EB4', ["A(~",      "\x102",    "A"]),
    ('\x1EB5', ["a(~",      "\x103",    "a"]),
    ('\x1EB6', ["A(.",      "\x102",    "A"]),
    ('\x1EB7', ["a(.",      "\x103",    "a"]),
    ('\x1EB8', ["E.",       "E"]),
    ('\x1EB9', ["e.",       "e"]),
    ('\x1EBA', ["E?",       "E"]),
    ('\x1EBB', ["e?",       "e"]),
    ('\x1EBC', ["E~",       "E"]),
    ('\x1EBD', ["e~",       "e"]),
    ('\x1EBE', ["E^'",      "\xCA",     "E"]),
    ('\x1EBF', ["e^'",      "\xEA",     "e"]),
    ('\x1EC0', ["E^`",      "\xCA",     "E"]),
    ('\x1EC1', ["e^`",      "\xEA",     "e"]),
    ('\x1EC2', ["E^?",      "\xCA",     "E"]),
    ('\x1EC3', ["e^?",      "\xEA",     "e"]),
    ('\x1EC4', ["E^~",      "\xCA",     "E"]),
    ('\x1EC5', ["e^~",      "\xEA",     "e"]),
    ('\x1EC6', ["E^.",      "\xCA",     "E"]),
    ('\x1EC7', ["e^.",      "\xEA",     "e"]),
    ('\x1EC8', ["I?",       "I"]),
    ('\x1EC9', ["i?",       "i"]),
    ('\x1ECA', ["I.",       "I"]),
    ('\x1ECB', ["i.",       "i"]),
    ('\x1ECC', ["O.",       "O"]),
    ('\x1ECD', ["o.",       "o"]),
    ('\x1ECE', ["O?",       "O"]),
    ('\x1ECF', ["o?",       "o"]),
    ('\x1ED0', ["O^'",      "\xD4",     "O"]),
    ('\x1ED1', ["o^'",      "\xF4",     "o"]),
    ('\x1ED2', ["O^`",      "\xD4",     "O"]),
    ('\x1ED3', ["o^`",      "\xF4",     "o"]),
    ('\x1ED4', ["O^?",      "\xD4",     "O"]),
    ('\x1ED5', ["o^?",      "\xF4",     "o"]),
    ('\x1ED6', ["O^~",      "\xD4",     "O"]),
    ('\x1ED7', ["o^~",      "\xF4",     "o"]),
    ('\x1ED8', ["O^.",      "\xD4",     "O"]),
    ('\x1ED9', ["o^.",      "\xF4",     "o"]),
    ('\x1EDA', ["O+'",      "\x1A0",    "O"]),
    ('\x1EDB', ["o+'",      "\x1A1",    "o"]),
    ('\x1EDC', ["O+`",      "\x1A0",    "O"]),
    ('\x1EDD', ["o+`",      "\x1A1",    "o"]),
    ('\x1EDE', ["O+?",      "\x1A0",    "O"]),
    ('\x1EDF', ["o+?",      "\x1A1",    "o"]),
    ('\x1EE0', ["O+~",      "\x1A0",    "O"]),
    ('\x1EE1', ["o+~",      "\x1A1",    "o"]),
    ('\x1EE2', ["O+.",      "\x1A0",    "O"]),
    ('\x1EE3', ["o+.",      "\x1A1",    "o"]),
    ('\x1EE4', ["U.",       "U"]),
    ('\x1EE5', ["u.",       "u"]),
    ('\x1EE6', ["U?",       "U"]),
    ('\x1EE7', ["u?",       "u"]),
    ('\x1EE8', ["U+'",      "\x1AF",    "U"]),
    ('\x1EE9', ["u+'",      "\x1B0",    "u"]),
    ('\x1EEA', ["U+`",      "\x1AF",    "U"]),
    ('\x1EEB', ["u+`",      "\x1B0",    "u"]),
    ('\x1EEC', ["U+?",      "\x1AF",    "U"]),
    ('\x1EED', ["u+?",      "\x1B0",    "u"]),
    ('\x1EEE', ["U+~",      "\x1AF",    "U"]),
    ('\x1EEF', ["u+~",      "\x1B0",    "u"]),
    ('\x1EF0', ["U+.",      "\x1AF",    "U"]),
    ('\x1EF1', ["u+.",      "\x1B0",    "u"]),
    ('\x1EF2', ["Y`",       "Y"]),
    ('\x1EF3', ["y`",       "y"]),
    ('\x1EF4', ["Y.",       "Y"]),
    ('\x1EF5', ["y.",       "y"]),
    ('\x1EF6', ["Y?",       "Y"]),
    ('\x1EF7', ["y?",       "y"]),
    ('\x1EF8', ["Y~",       "Y"]),
    ('\x1EF9', ["y~",       "y"]),
    ('\x1F00', ["\x3B1",    "a"]),
    ('\x1F01', ["\x3B1",    "a"]),
    ('\x1F02', ["\x3B1",    "a"]),
    ('\x1F03', ["\x3B1",    "a"]),
    ('\x1F04', ["\x3B1",    "a"]),
    ('\x1F05', ["\x3B1",    "a"]),
    ('\x1F06', ["\x3B1",    "a"]),
    ('\x1F07', ["\x3B1",    "a"]),
    ('\x1F08', ["\x391",    "A"]),
    ('\x1F09', ["\x391",    "A"]),
    ('\x1F0A', ["\x391",    "A"]),
    ('\x1F0B', ["\x391",    "A"]),
    ('\x1F0C', ["\x391",    "A"]),
    ('\x1F0D', ["\x391",    "A"]),
    ('\x1F0E', ["\x391",    "A"]),
    ('\x1F0F', ["\x391",    "A"]),
    ('\x1F10', ["\x3B5",    "e"]),
    ('\x1F11', ["\x3B5",    "e"]),
    ('\x1F12', ["\x3B5",    "e"]),
    ('\x1F13', ["\x3B5",    "e"]),
    ('\x1F14', ["\x3B5",    "e"]),
    ('\x1F15', ["\x3B5",    "e"]),
    ('\x1F18', ["\x395",    "E"]),
    ('\x1F19', ["\x395",    "E"]),
    ('\x1F1A', ["\x395",    "E"]),
    ('\x1F1B', ["\x395",    "E"]),
    ('\x1F1C', ["\x395",    "E"]),
    ('\x1F1D', ["\x395",    "E"]),
    ('\x1F20', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F21', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F22', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F23', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F24', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F25', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F26', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F27', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F28', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F29', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F2A', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F2B', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F2C', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F2D', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F2E', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F2F', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F30', ["\x3B9",    "i"]),
    ('\x1F31', ["\x3B9",    "i"]),
    ('\x1F32', ["\x3B9",    "i"]),
    ('\x1F33', ["\x3B9",    "i"]),
    ('\x1F34', ["\x3B9",    "i"]),
    ('\x1F35', ["\x3B9",    "i"]),
    ('\x1F36', ["\x3B9",    "i"]),
    ('\x1F37', ["\x3B9",    "i"]),
    ('\x1F38', ["\x399",    "I"]),
    ('\x1F39', ["\x399",    "I"]),
    ('\x1F3A', ["\x399",    "I"]),
    ('\x1F3B', ["\x399",    "I"]),
    ('\x1F3C', ["\x399",    "I"]),
    ('\x1F3D', ["\x399",    "I"]),
    ('\x1F3E', ["\x399",    "I"]),
    ('\x1F3F', ["\x399",    "I"]),
    ('\x1F40', ["\x3BF",    "o"]),
    ('\x1F41', ["\x3BF",    "o"]),
    ('\x1F42', ["\x3BF",    "o"]),
    ('\x1F43', ["\x3BF",    "o"]),
    ('\x1F44', ["\x3BF",    "o"]),
    ('\x1F45', ["\x3BF",    "o"]),
    ('\x1F48', ["\x39F",    "O"]),
    ('\x1F49', ["\x39F",    "O"]),
    ('\x1F4A', ["\x39F",    "O"]),
    ('\x1F4B', ["\x39F",    "O"]),
    ('\x1F4C', ["\x39F",    "O"]),
    ('\x1F4D', ["\x39F",    "O"]),
    ('\x1F50', ["\x3C5",    "u"]),
    ('\x1F51', ["\x3C5",    "u"]),
    ('\x1F52', ["\x3C5",    "u"]),
    ('\x1F53', ["\x3C5",    "u"]),
    ('\x1F54', ["\x3C5",    "u"]),
    ('\x1F55', ["\x3C5",    "u"]),
    ('\x1F56', ["\x3C5",    "u"]),
    ('\x1F57', ["\x3C5",    "u"]),
    ('\x1F59', ["\x3A5",    "U"]),
    ('\x1F5B', ["\x3A5",    "U"]),
    ('\x1F5D', ["\x3A5",    "U"]),
    ('\x1F5F', ["\x3A5",    "U"]),
    ('\x1F60', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1F61', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1F62', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1F63', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1F64', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1F65', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1F66', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1F67', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1F68', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1F69', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1F6A', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1F6B', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1F6C', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1F6D', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1F6E', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1F6F', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1F70', ["\x3B1",    "a"]),
    ('\x1F71', ["\x3B1",    "a"]),
    ('\x1F72', ["\x3B5",    "e"]),
    ('\x1F73', ["\x3B5",    "e"]),
    ('\x1F74', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F75', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F76', ["\x3B9",    "i"]),
    ('\x1F77', ["\x3B9",    "i"]),
    ('\x1F78', ["\x3BF",    "o"]),
    ('\x1F79', ["\x3BF",    "o"]),
    ('\x1F7A', ["\x3C5",    "u"]),
    ('\x1F7B', ["\x3C5",    "u"]),
    ('\x1F7C', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1F7D', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1F80', ["\x3B1",    "a"]),
    ('\x1F81', ["\x3B1",    "a"]),
    ('\x1F82', ["\x3B1",    "a"]),
    ('\x1F83', ["\x3B1",    "a"]),
    ('\x1F84', ["\x3B1",    "a"]),
    ('\x1F85', ["\x3B1",    "a"]),
    ('\x1F86', ["\x3B1",    "a"]),
    ('\x1F87', ["\x3B1",    "a"]),
    ('\x1F88', ["\x391",    "A"]),
    ('\x1F89', ["\x391",    "A"]),
    ('\x1F8A', ["\x391",    "A"]),
    ('\x1F8B', ["\x391",    "A"]),
    ('\x1F8C', ["\x391",    "A"]),
    ('\x1F8D', ["\x391",    "A"]),
    ('\x1F8E', ["\x391",    "A"]),
    ('\x1F8F', ["\x391",    "A"]),
    ('\x1F90', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F91', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F92', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F93', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F94', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F95', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F96', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F97', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1F98', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F99', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F9A', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F9B', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F9C', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F9D', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F9E', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1F9F', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1FA0', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1FA1', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1FA2', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1FA3', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1FA4', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1FA5', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1FA6', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1FA7', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1FA8', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1FA9', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1FAA', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1FAB', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1FAC', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1FAD', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1FAE', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1FAF', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1FB0', ["\x3B1",    "a"]),
    ('\x1FB1', ["\x3B1",    "a"]),
    ('\x1FB2', ["\x3B1",    "a"]),
    ('\x1FB3', ["\x3B1",    "a"]),
    ('\x1FB4', ["\x3B1",    "a"]),
    ('\x1FB6', ["\x3B1",    "a"]),
    ('\x1FB7', ["\x3B1",    "a"]),
    ('\x1FB8', ["\x391",    "A"]),
    ('\x1FB9', ["\x391",    "A"]),
    ('\x1FBA', ["\x391",    "A"]),
    ('\x1FBB', ["\x391",    "A"]),
    ('\x1FBC', ["\x391",    "A"]),
    ('\x1FBD', [" "]),
    ('\x1FBE', [" "]),
    ('\x1FBF', [" "]),
    ('\x1FC0', [" "]),
    ('\x1FC1', [" "]),
    ('\x1FC2', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1FC3', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1FC4', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1FC6', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1FC7', ["\x3B7",    "\x113",    "eh",       "e"]),
    ('\x1FC8', ["\x395",    "E"]),
    ('\x1FC9', ["\x395",    "E"]),
    ('\x1FCA', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1FCB', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1FCC', ["\x397",    "\x112",    "EH",       "E"]),
    ('\x1FCD', [" "]),
    ('\x1FCE', [" "]),
    ('\x1FCF', [" "]),
    ('\x1FD0', ["\x3B9",    "i"]),
    ('\x1FD1', ["\x3B9",    "i"]),
    ('\x1FD2', ["\x3CA",    "i"]),
    ('\x1FD3', ["\x3CA",    "i"]),
    ('\x1FD6', ["\x3B9",    "i"]),
    ('\x1FD7', ["\x3B9",    "i"]),
    ('\x1FD8', ["\x399",    "I"]),
    ('\x1FD9', ["\x399",    "I"]),
    ('\x1FDA', ["\x399",    "I"]),
    ('\x1FDB', ["\x399",    "I"]),
    ('\x1FDD', [" "]),
    ('\x1FDE', [" "]),
    ('\x1FDF', [" "]),
    ('\x1FE0', ["\x3C5",    "u"]),
    ('\x1FE1', ["\x3C5",    "u"]),
    ('\x1FE2', ["\x3CB",    "u"]),
    ('\x1FE3', ["\x3CB",    "u"]),
    ('\x1FE4', ["\x3C1",    "r"]),
    ('\x1FE5', ["\x3C1",    "r"]),
    ('\x1FE6', ["\x3C5",    "u"]),
    ('\x1FE7', ["\x3CB",    "u"]),
    ('\x1FE8', ["\x3A5",    "U"]),
    ('\x1FE9', ["\x3A5",    "U"]),
    ('\x1FEA', ["\x3A5",    "U"]),
    ('\x1FEB', ["\x3A5",    "U"]),
    ('\x1FEC', ["\x3A1",    "R"]),
    ('\x1FED', [" "]),
    ('\x1FEE', [" "]),
    ('\x1FEF', [" "]),
    ('\x1FF2', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1FF3', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1FF4', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1FF6', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1FF7', ["\x3C9",    "\x14D",    "oh",       "o"]),
    ('\x1FF8', ["\x39F",    "O"]),
    ('\x1FF9', ["\x39F",    "O"]),
    ('\x1FFA', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1FFB', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1FFC', ["\x3A9",    "\x14C",    "OH",       "O"]),
    ('\x1FFD', [" "]),
    ('\x1FFE', [" "]),
    ('\x2002', [" "]),
    ('\x2003', [" "]),
    ('\x2009', [" "]),
    ('\x200C', ["&",        " "]),
    ('\x200D', ["&",        " "]),
    ('\x200E', ["[->]",     ">"]),
    ('\x200F', ["[<-]",     "<"]),
    ('\x2010', ["-"]),
    ('\x2011', ["\x2010",   "-"]),
    ('\x2012', ["\x2013",   "-"]),
    ('\x2013', ["-"]),
    ('\x2014', ["\x2015",   "--",       "-"]),
    ('\x2015', ["\x2014",   "--",       "-"]),
    ('\x2016', ["||",       "|"]),
    ('\x2017', ["_"]),
    ('\x2018', ["`"]),
    ('\x2019', ["'"]),
    ('\x201A', [","]),
    ('\x201B', ["\x2018",   "`"]),
    ('\x201C', ["\""]),
    ('\x201D', ["\""]),
    ('\x201E', ["\x201C",   "\""]),
    ('\x201F', ["\""]),
    ('\x2020', ["\x253C",   "+"]),
    ('\x2021', ["\x256A",   "\x256C",   "++",       "\x253C",   "+"]),
    ('\x2022', ["\x2219",   "\xB7",     "*"]),
    ('\x2023', [">"]),
    ('\x2024', ["."]),
    ('\x2025', ["..",       "."]),
    ('\x2026', ["...",      "."]),
    ('\x2027', ["\xB7",     "-"]),
    ('\x2028', ["\n"]),
    ('\x2029', ["\n"]),
    ('\x2030', ["%%"]),
    ('\x2031', ["%%%"]),
    ('\x2032', ["'"]),
    ('\x2033', ["''"]),
    ('\x2034', ["'''"]),
    ('\x2035', ["`"]),
    ('\x2036', ["``"]),
    ('\x2037', ["```"]),
    ('\x2038', ["^"]),
    ('\x2039', ["<"]),
    ('\x203A', [">"]),
    ('\x203B', [":X",       "X"]),
    ('\x203C', ["!!",       "!"]),
    ('\x203D', ["?!"]),
    ('\x203E', ["-"]),
    ('\x203F', ["_"]),
    ('\x2040', ["~"]),
    ('\x2041', [","]),
    ('\x2042', ["***",      "*"]),
    ('\x2043', ["-"]),
    ('\x2044', ["/"]),
    ('\x2045', ["["]),
    ('\x2046', ["]"]),
    ('\x2070', ["^0",       "0"]),
    ('\x2074', ["^4",       "4"]),
    ('\x2075', ["^5",       "5"]),
    ('\x2076', ["^6",       "6"]),
    ('\x2077', ["^7",       "7"]),
    ('\x2078', ["^8",       "8"]),
    ('\x2079', ["^9",       "9"]),
    ('\x207A', ["^+",       "+"]),
    ('\x207B', ["^-",       "-"]),
    ('\x207C', ["^=",       "="]),
    ('\x207D', ["^(",       "("]),
    ('\x207E', ["^)",       ")"]),
    ('\x207F', ["^n",       "n"]),
    ('\x2080', ["_0",       "0"]),
    ('\x2081', ["_1",       "1"]),
    ('\x2082', ["_2",       "2"]),
    ('\x2083', ["_3",       "3"]),
    ('\x2084', ["_4",       "4"]),
    ('\x2085', ["_5",       "5"]),
    ('\x2086', ["_6",       "6"]),
    ('\x2087', ["_7",       "7"]),
    ('\x2088', ["_8",       "8"]),
    ('\x2089', ["_9",       "9"]),
    ('\x208A', ["_+",       "+"]),
    ('\x208B', ["_-",       "-"]),
    ('\x208C', ["_=",       "="]),
    ('\x208D', ["_(",       "("]),
    ('\x208E', ["_)",       ")"]),
    ('\x20A0', ["CE"]),
    ('\x20A1', ["C/",       "C"]),
    ('\x20A2', ["Cr",       "C"]),
    ('\x20A3', ["Fr",       "F"]),
    ('\x20A4', ["\xA3",     "L"]),
    ('\x20A5', ["m"]),
    ('\x20A6', ["N"]),
    ('\x20A7', ["Pts",      "P"]),
    ('\x20A8', ["Rs",       "R"]),
    ('\x20A9', ["W"]),
    ('\x20AA', ["ILS"]),
    ('\x20AB', ["VND"]),
    ('\x20AC', ["Euro",     "E"]),
    ('\x2100', ["a/c"]),
    ('\x2101', ["a/s"]),
    ('\x2102', ["C"]),
    ('\x2103', ["\xB0\&C",  "oC",       "C"]),
    ('\x2104', ["CL"]),
    ('\x2105', ["c/o"]),
    ('\x2106', ["c/u"]),
    ('\x2107', ["E"]),
    ('\x2108', ["E"]),
    ('\x2109', ["\xB0\&F",  "oF",       "F"]),
    ('\x210A', ["g"]),
    ('\x210B', ["H"]),
    ('\x210C', ["H"]),
    ('\x210D', ["H"]),
    ('\x210E', ["h"]),
    ('\x210F', ["/h",       "h"]),
    ('\x2110', ["I"]),
    ('\x2111', ["Im",       "I"]),
    ('\x2112', ["L"]),
    ('\x2113', ["l"]),
    ('\x2114', ["lb"]),
    ('\x2115', ["N"]),
    ('\x2116', ["No.",      "#"]),
    ('\x2117', ["(P)",      "P"]),
    ('\x2118', ["p"]),
    ('\x2119', ["P"]),
    ('\x211A', ["Q"]),
    ('\x211B', ["R"]),
    ('\x211C', ["Re",       "R"]),
    ('\x211D', ["R"]),
    ('\x211E', ["Rx",       "R"]),
    ('\x211F', ["R"]),
    ('\x2120', ["(SM)"]),
    ('\x2121', ["(TEL)"]),
    ('\x2122', ["(TM)"]),
    ('\x2123', ["V"]),
    ('\x2124', ["Z"]),
    ('\x2125', ["z"]),
    ('\x2126', ["\x3A9",    "OHM",      "O"]),
    ('\x2127', ["MHO"]),
    ('\x2128', ["Z"]),
    ('\x2129', ["i"]),
    ('\x212A', ["K"]),
    ('\x212B', ["\xC5",     "A"]),
    ('\x212C', ["B"]),
    ('\x212D', ["C"]),
    ('\x212E', ["est.",     "e"]),
    ('\x212F', ["e"]),
    ('\x2130', ["E"]),
    ('\x2131', ["F"]),
    ('\x2132', ["F"]),
    ('\x2133', ["M"]),
    ('\x2134', ["o"]),
    ('\x2135', ["alef"]),
    ('\x2136', ["bet"]),
    ('\x2137', ["gimel"]),
    ('\x2138', ["dalet"]),
    ('\x2153', [" 1/3"]),
    ('\x2154', [" 2/3"]),
    ('\x2155', [" 1/5"]),
    ('\x2156', [" 2/5"]),
    ('\x2157', [" 3/5"]),
    ('\x2158', [" 4/5"]),
    ('\x2159', [" 1/6"]),
    ('\x215A', [" 5/6"]),
    ('\x215B', [" 1/8"]),
    ('\x215C', [" 3/8"]),
    ('\x215D', [" 5/8"]),
    ('\x215E', [" 7/8"]),
    ('\x215F', [" 1/"]),
    ('\x2160', ["I"]),
    ('\x2161', ["II"]),
    ('\x2162', ["III"]),
    ('\x2163', ["IV"]),
    ('\x2164', ["V"]),
    ('\x2165', ["VI"]),
    ('\x2166', ["VII"]),
    ('\x2167', ["VIII"]),
    ('\x2168', ["IX"]),
    ('\x2169', ["X"]),
    ('\x216A', ["XI"]),
    ('\x216B', ["XII"]),
    ('\x216C', ["L"]),
    ('\x216D', ["C"]),
    ('\x216E', ["D"]),
    ('\x216F', ["M"]),
    ('\x2170', ["i"]),
    ('\x2171', ["ii"]),
    ('\x2172', ["iii"]),
    ('\x2173', ["iv"]),
    ('\x2174', ["v"]),
    ('\x2175', ["vi"]),
    ('\x2176', ["vii"]),
    ('\x2177', ["viii"]),
    ('\x2178', ["ix"]),
    ('\x2179', ["x"]),
    ('\x217A', ["xi"]),
    ('\x217B', ["xii"]),
    ('\x217C', ["l"]),
    ('\x217D', ["c"]),
    ('\x217E', ["d"]),
    ('\x217F', ["m"]),
    ('\x2180', ["1000"]),
    ('\x2181', ["5000"]),
    ('\x2182', ["10000"]),
    ('\x2190', ["<-",       "<"]),
    ('\x2191', ["^"]),
    ('\x2192', ["->",       ">"]),
    ('\x2193', ["v"]),
    ('\x2194', ["<->",      "-"]),
    ('\x2195', ["|"]),
    ('\x21A8', ["|"]),
    ('\x21B5', ["RET"]),
    ('\x21D0', ["<=",       "<"]),
    ('\x21D1', ["^"]),
    ('\x21D2', ["=>",       ">"]),
    ('\x21D3', ["v"]),
    ('\x21D4', ["<=>",      "="]),
    ('\x2200', ["FA ",      "A"]),
    ('\x2202', ["d"]),
    ('\x2203', ["TE ",      "E"]),
    ('\x2205', ["\xD8",     "0"]),
    ('\x2206', ["\x394",    "D"]),
    ('\x2207', ["Nabla"]),
    ('\x2208', ["\x3B5",    "(-",       "("]),
    ('\x2209', ["!\x2208",  "!\x3B5",   "!(-"]),
    ('\x220B', ["-)",       ")"]),
    ('\x220C', ["!\x220B",  "!-)"]),
    ('\x220E', ["QED"]),
    ('\x220F', ["\x3A0",    "PROD ",    "\x2565",   "P"]),
    ('\x2210', ["COPROD "]),
    ('\x2211', ["\x3A3",    "SUM ",     "S"]),
    ('\x2212', ["-"]),
    ('\x2213', ["-+"]),
    ('\x2214', [".+"]),
    ('\x2215', ["/"]),
    ('\x2216', ["\\"]),
    ('\x2217', ["*"]),
    ('\x2218', ["\xB0",     "\x2DA",    "o"]),
    ('\x2219', ["\x2022",   "\xB7",     "*"]),
    ('\x221A', ["SQRT ",    "V"]),
    ('\x221B', ["\xB3\x221A", "\xB3\\/", " 3\x221A", " 3\\/"]),
    ('\x221C', ["\x2074\x221A", "\x2074\\/", " 4\x221A", " 4\\/"]),
    ('\x221E', ["oo",       "%"]),
    ('\x221F', ["-L",       "L"]),
    ('\x2220', ["-V",       "V"]),
    ('\x2223', ["|"]),
    ('\x2224', ["!|"]),
    ('\x2225', ["||"]),
    ('\x2226', ["!||"]),
    ('\x2227', ["&"]),
    ('\x2228', ["|"]),
    ('\x2229', ["*"]),
    ('\x222A', ["+"]),
    ('\x222B', ["INT "]),
    ('\x2234', [".:"]),
    ('\x2235', [":."]),
    ('\x2236', [":"]),
    ('\x2237', ["::"]),
    ('\x223C', ["~"]),
    ('\x2245', ["~=",       "~"]),
    ('\x2248', ["~=",       "~"]),
    ('\x2249', ["!\x2248",  "!~="]),
    ('\x2254', [":=",       "="]),
    ('\x2255', ["=:",       "="]),
    ('\x2260', ["!=",       "\x256A",   "!"]),
    ('\x2261', ["==",       "="]),
    ('\x2262', ["!\x2261",  "!=="]),
    ('\x2264', ["<=",       "<"]),
    ('\x2265', [">=",       ">"]),
    ('\x226A', ["<<",       "<"]),
    ('\x226B', [">>",       ">"]),
    ('\x226E', ["!<"]),
    ('\x226F', ["!>"]),
    ('\x2282', ["("]),
    ('\x2283', [")"]),
    ('\x2284', ["!("]),
    ('\x2285', ["!)"]),
    ('\x2286', ["(="]),
    ('\x2287', [")="]),
    ('\x2295', ["(+)",      "+"]),
    ('\x2297', ["(x)",      "x"]),
    ('\x2299', ["(\xB7)",   "(.)",      "\xB7",     "."]),
    ('\x229A', ["(\x2218)", "(o)",      "\x2218",   "o"]),
    ('\x22A5', ["\x2534",   "_|_"]),
    ('\x22C5', ["\xB7",     "\x2219",   "\x2022",   "."]),
    ('\x22D5', ["#"]),
    ('\x22EE', ["\x2026",   "...",      "."]),
    ('\x22EF', ["\x2026",   "...",      "."]),
    ('\x22F0', ["\x2026",   "...",      "."]),
    ('\x22F1', ["\x2026",   "...",      "."]),
    ('\x2302', ["^"]),
    ('\x2310', ["\xAC",     "-"]),
    ('\x2318', ["88",       "8"]),
    ('\x2320', ["/"]),
    ('\x2321', ["/"]),
    ('\x2400', ["NUL",      "@"]),
    ('\x2401', ["SOH",      "A"]),
    ('\x2402', ["STX",      "B"]),
    ('\x2403', ["ETX",      "C"]),
    ('\x2404', ["EOT",      "D"]),
    ('\x2405', ["ENQ",      "E"]),
    ('\x2406', ["ACK",      "F"]),
    ('\x2407', ["BEL",      "G"]),
    ('\x2408', ["BS",       "H"]),
    ('\x2409', ["HT",       "I"]),
    ('\x240A', ["LF",       "J"]),
    ('\x240B', ["VT",       "K"]),
    ('\x240C', ["FF",       "L"]),
    ('\x240D', ["CR",       "M"]),
    ('\x240E', ["SO",       "N"]),
    ('\x240F', ["SI",       "O"]),
    ('\x2410', ["DLE",      "P"]),
    ('\x2411', ["DC1",      "Q"]),
    ('\x2412', ["DC2",      "R"]),
    ('\x2413', ["DC3",      "S"]),
    ('\x2414', ["DC4",      "T"]),
    ('\x2415', ["NAK",      "U"]),
    ('\x2416', ["SYN",      "V"]),
    ('\x2417', ["ETB",      "W"]),
    ('\x2418', ["CAN",      "X"]),
    ('\x2419', ["EM",       "Y"]),
    ('\x241A', ["SUB",      "Z"]),
    ('\x241B', ["ESC",      "["]),
    ('\x241C', ["FS",       "\\"]),
    ('\x241D', ["GS",       "]"]),
    ('\x241E', ["RS",       "^"]),
    ('\x241F', ["US",       "_"]),
    ('\x2420', ["SP",       "_"]),
    ('\x2421', ["DEL",      "?"]),
    ('\x2422', ["/b",       "b"]),
    ('\x2423', ["_"]),
    ('\x2424', ["NL"]),
    ('\x2460', ["(1)",      "1"]),
    ('\x2461', ["(2)",      "2"]),
    ('\x2462', ["(3)",      "3"]),
    ('\x2463', ["(4)",      "4"]),
    ('\x2464', ["(5)",      "5"]),
    ('\x2465', ["(6)",      "6"]),
    ('\x2466', ["(7)",      "7"]),
    ('\x2467', ["(8)",      "8"]),
    ('\x2468', ["(9)",      "9"]),
    ('\x2469', ["(10)"]),
    ('\x246A', ["(11)"]),
    ('\x246B', ["(12)"]),
    ('\x246C', ["(13)"]),
    ('\x246D', ["(14)"]),
    ('\x246E', ["(15)"]),
    ('\x246F', ["(16)"]),
    ('\x2470', ["(17)"]),
    ('\x2471', ["(18)"]),
    ('\x2472', ["(19)"]),
    ('\x2473', ["(20)"]),
    ('\x2474', ["(1)",      "1"]),
    ('\x2475', ["(2)",      "2"]),
    ('\x2476', ["(3)",      "3"]),
    ('\x2477', ["(4)",      "4"]),
    ('\x2478', ["(5)",      "5"]),
    ('\x2479', ["(6)",      "6"]),
    ('\x247A', ["(7)",      "7"]),
    ('\x247B', ["(8)",      "8"]),
    ('\x247C', ["(9)",      "9"]),
    ('\x247D', ["(10)"]),
    ('\x247E', ["(11)"]),
    ('\x247F', ["(12)"]),
    ('\x2480', ["(13)"]),
    ('\x2481', ["(14)"]),
    ('\x2482', ["(15)"]),
    ('\x2483', ["(16)"]),
    ('\x2484', ["(17)"]),
    ('\x2485', ["(18)"]),
    ('\x2486', ["(19)"]),
    ('\x2487', ["(20)"]),
    ('\x2488', ["1.",       "1"]),
    ('\x2489', ["2.",       "2"]),
    ('\x248A', ["3.",       "3"]),
    ('\x248B', ["4.",       "4"]),
    ('\x248C', ["5.",       "5"]),
    ('\x248D', ["6.",       "6"]),
    ('\x248E', ["7.",       "7"]),
    ('\x248F', ["8.",       "8"]),
    ('\x2490', ["9.",       "9"]),
    ('\x2491', ["10."]),
    ('\x2492', ["11."]),
    ('\x2493', ["12."]),
    ('\x2494', ["13."]),
    ('\x2495', ["14."]),
    ('\x2496', ["15."]),
    ('\x2497', ["16."]),
    ('\x2498', ["17."]),
    ('\x2499', ["18."]),
    ('\x249A', ["19."]),
    ('\x249B', ["20."]),
    ('\x249C', ["(a)",      "a"]),
    ('\x249D', ["(b)",      "b"]),
    ('\x249E', ["(c)",      "c"]),
    ('\x249F', ["(d)",      "d"]),
    ('\x24A0', ["(e)",      "e"]),
    ('\x24A1', ["(f)",      "f"]),
    ('\x24A2', ["(g)",      "g"]),
    ('\x24A3', ["(h)",      "h"]),
    ('\x24A4', ["(i)",      "i"]),
    ('\x24A5', ["(j)",      "j"]),
    ('\x24A6', ["(k)",      "k"]),
    ('\x24A7', ["(l)",      "l"]),
    ('\x24A8', ["(m)",      "m"]),
    ('\x24A9', ["(n)",      "n"]),
    ('\x24AA', ["(o)",      "o"]),
    ('\x24AB', ["(p)",      "p"]),
    ('\x24AC', ["(q)",      "q"]),
    ('\x24AD', ["(r)",      "r"]),
    ('\x24AE', ["(s)",      "s"]),
    ('\x24AF', ["(t)",      "t"]),
    ('\x24B0', ["(u)",      "u"]),
    ('\x24B1', ["(v)",      "v"]),
    ('\x24B2', ["(w)",      "w"]),
    ('\x24B3', ["(x)",      "x"]),
    ('\x24B4', ["(y)",      "y"]),
    ('\x24B5', ["(z)",      "z"]),
    ('\x24B6', ["(A)",      "A"]),
    ('\x24B7', ["(B)",      "B"]),
    ('\x24B8', ["(C)",      "C"]),
    ('\x24B9', ["(D)",      "D"]),
    ('\x24BA', ["(E)",      "E"]),
    ('\x24BB', ["(F)",      "F"]),
    ('\x24BC', ["(G)",      "G"]),
    ('\x24BD', ["(H)",      "H"]),
    ('\x24BE', ["(I)",      "I"]),
    ('\x24BF', ["(J)",      "J"]),
    ('\x24C0', ["(K)",      "K"]),
    ('\x24C1', ["(L)",      "L"]),
    ('\x24C2', ["(M)",      "M"]),
    ('\x24C3', ["(N)",      "N"]),
    ('\x24C4', ["(O)",      "O"]),
    ('\x24C5', ["(P)",      "P"]),
    ('\x24C6', ["(Q)",      "Q"]),
    ('\x24C7', ["(R)",      "R"]),
    ('\x24C8', ["(S)",      "S"]),
    ('\x24C9', ["(T)",      "T"]),
    ('\x24CA', ["(U)",      "U"]),
    ('\x24CB', ["(V)",      "V"]),
    ('\x24CC', ["(W)",      "W"]),
    ('\x24CD', ["(X)",      "X"]),
    ('\x24CE', ["(Y)",      "Y"]),
    ('\x24CF', ["(Z)",      "Z"]),
    ('\x24D0', ["(a)",      "a"]),
    ('\x24D1', ["(b)",      "b"]),
    ('\x24D2', ["(c)",      "c"]),
    ('\x24D3', ["(d)",      "d"]),
    ('\x24D4', ["(e)",      "e"]),
    ('\x24D5', ["(f)",      "f"]),
    ('\x24D6', ["(g)",      "g"]),
    ('\x24D7', ["(h)",      "h"]),
    ('\x24D8', ["(i)",      "i"]),
    ('\x24D9', ["(j)",      "j"]),
    ('\x24DA', ["(k)",      "k"]),
    ('\x24DB', ["(l)",      "l"]),
    ('\x24DC', ["(m)",      "m"]),
    ('\x24DD', ["(n)",      "n"]),
    ('\x24DE', ["(o)",      "o"]),
    ('\x24DF', ["(p)",      "p"]),
    ('\x24E0', ["(q)",      "q"]),
    ('\x24E1', ["(r)",      "r"]),
    ('\x24E2', ["(s)",      "s"]),
    ('\x24E3', ["(t)",      "t"]),
    ('\x24E4', ["(u)",      "u"]),
    ('\x24E5', ["(v)",      "v"]),
    ('\x24E6', ["(w)",      "w"]),
    ('\x24E7', ["(x)",      "x"]),
    ('\x24E8', ["(y)",      "y"]),
    ('\x24E9', ["(z)",      "z"]),
    ('\x24EA', ["(0)",      "0"]),
    ('\x2500', ["-"]),
    ('\x2501', ["\x2550",   "\x2500",   "="]),
    ('\x2502', ["|"]),
    ('\x2503', ["\x2551",   "\x2502",   "|"]),
    ('\x2504', ["\x2500",   "-"]),
    ('\x2505', ["\x2550",   "\x2500",   "="]),
    ('\x2506', ["\x2502",   "|"]),
    ('\x2507', ["\x2551",   "\x2502",   "|"]),
    ('\x2508', ["\x2500",   "-"]),
    ('\x2509', ["\x2550",   "\x2500",   "="]),
    ('\x250A', ["\x2502",   "|"]),
    ('\x250B', ["\x2551",   "\x2502",   "|"]),
    ('\x250C', ["+"]),
    ('\x250D', ["\x2552",   "\x250C",   "+"]),
    ('\x250E', ["\x2553",   "\x250C",   "+"]),
    ('\x250F', ["\x2554",   "\x250C",   "+"]),
    ('\x2510', ["+"]),
    ('\x2511', ["\x2555",   "\x2510",   "+"]),
    ('\x2512', ["\x2556",   "\x2510",   "+"]),
    ('\x2513', ["\x2557",   "\x2510",   "+"]),
    ('\x2514', ["+"]),
    ('\x2515', ["\x2558",   "\x2514",   "+"]),
    ('\x2516', ["\x2559",   "\x2514",   "+"]),
    ('\x2517', ["\x255A",   "\x2514",   "+"]),
    ('\x2518', ["+"]),
    ('\x2519', ["\x255B",   "\x2518",   "+"]),
    ('\x251A', ["\x255C",   "\x2518",   "+"]),
    ('\x251B', ["\x255D",   "\x2518",   "+"]),
    ('\x251C', ["|"]),
    ('\x251D', ["\x255E",   "\x2502\0\x2550", "\x251C", "|"]),
    ('\x251E', ["\x251C",   "|"]),
    ('\x251F', ["\x251C",   "|"]),
    ('\x2520', ["\x255F",   "\x2551",   "\x251C",   "|"]),
    ('\x2521', ["\x255E",   "\x2502\0\x2550", "\x251C", "|"]),
    ('\x2522', ["\x255E",   "\x2502\0\x2550", "\x251C", "|"]),
    ('\x2523', ["\x2560",   "\x251C",   "|"]),
    ('\x2524', ["|"]),
    ('\x2525', ["\x2561",   "\x2502\0\x2550", "\x2524", "|"]),
    ('\x2526', ["\x2524",   "|"]),
    ('\x2527', ["\x2524",   "|"]),
    ('\x2528', ["\x2562",   "\x2551",   "\x2524",   "|"]),
    ('\x2529', ["\x2561",   "\x2502\0\x2550", "\x2524", "|"]),
    ('\x252A', ["\x2561",   "\x2502\0\x2550", "\x2524", "|"]),
    ('\x252B', ["\x2563",   "\x2524",   "|"]),
    ('\x252C', ["-"]),
    ('\x252D', ["\x252C",   "-"]),
    ('\x252E', ["\x252C",   "-"]),
    ('\x252F', ["\x2564",   "\x2550",   "\x252C",   "="]),
    ('\x2530', ["\x2565",   "\x2500\0\x2551", "\x252C", "-"]),
    ('\x2531', ["\x2565",   "\x2500\0\x2551", "\x252C", "-"]),
    ('\x2532', ["\x2565",   "\x2500\0\x2551", "\x252C", "-"]),
    ('\x2533', ["\x2566",   "\x252C",   "="]),
    ('\x2534', ["-"]),
    ('\x2535', ["\x2534",   "-"]),
    ('\x2536', ["\x2534",   "-"]),
    ('\x2537', ["\x2567",   "\x2550",   "\x2534",   "="]),
    ('\x2538', ["\x2568",   "\x2500\0\x2551", "\x2534",   "-"]),
    ('\x2539', ["\x2568",   "\x2500\0\x2551", "\x2534",   "-"]),
    ('\x253A', ["\x2568",   "\x2500\0\x2551", "\x2534",   "-"]),
    ('\x253B', ["\x2569",   "\x2534",   "="]),
    ('\x253C', ["|"]),
    ('\x253D', ["\x253C",   "|"]),
    ('\x253E', ["\x253C",   "|"]),
    ('\x253F', ["\x256A",   "\x2502\0\x2550", "\x253C", "|"]),
    ('\x2540', ["\x253C",   "|"]),
    ('\x2541', ["\x253C",   "|"]),
    ('\x2542', ["\x256B",   "\x2551",   "\x253C",   "|"]),
    ('\x2543', ["\x253C",   "|"]),
    ('\x2544', ["\x253C",   "|"]),
    ('\x2545', ["\x253C",   "|"]),
    ('\x2546', ["\x253C",   "|"]),
    ('\x2547', ["\x256A",   "\x2502\0\x2550", "\x253C", "|"]),
    ('\x2548', ["\x256A",   "\x2502\0\x2550", "\x253C", "|"]),
    ('\x2549', ["\x256B",   "\x2551",   "\x253C",   "|"]),
    ('\x254A', ["\x256B",   "\x2551",   "\x253C",   "|"]),
    ('\x254B', ["\x256C",   "\x253C",   "|"]),
    ('\x254C', ["\x2500",   "-"]),
    ('\x254D', ["\x2550",   "\x2500",   "="]),
    ('\x254E', ["\x2502",   "|"]),
    ('\x254F', ["\x2551",   "\x2502",   "|"]),
    ('\x2550', ["\x2500",   "="]),
    ('\x2551', ["\x2502",   "|"]),
    ('\x2552', ["\x250C",   "+"]),
    ('\x2553', ["\x250C",   "+"]),
    ('\x2554', ["\x250C",   "+"]),
    ('\x2555', ["\x2510",   "+"]),
    ('\x2556', ["\x2510",   "+"]),
    ('\x2557', ["\x2510",   "+"]),
    ('\x2558', ["\x2514",   "+"]),
    ('\x2559', ["\x2514",   "+"]),
    ('\x255A', ["\x2514",   "+"]),
    ('\x255B', ["\x2518",   "+"]),
    ('\x255C', ["\x2518",   "+"]),
    ('\x255D', ["\x2518",   "+"]),
    ('\x255E', ["\x2502\0\x2550", "\x251C", "|"]),
    ('\x255F', ["\x2551",   "\x251C",   "|"]),
    ('\x2560', ["\x251C",   "|"]),
    ('\x2561', ["\x2502\0\x2550", "\x2524", "|"]),
    ('\x2562', ["\x2551",   "\x2524",   "|"]),
    ('\x2563', ["\x2524",   "|"]),
    ('\x2564', ["\x2550",   "\x252C",   "="]),
    ('\x2565', ["\x2500\0\x2551", "\x252C", "-"]),
    ('\x2566', ["\x252C",   "="]),
    ('\x2567', ["\x2550",   "\x2534",   "="]),
    ('\x2568', ["\x2500\0\x2551", "\x2534", "-"]),
    ('\x2569', ["\x2534",   "="]),
    ('\x256A', ["\x2502\0\x2550", "\x253C", "|"]),
    ('\x256B', ["\x2551",   "\x253C",   "|"]),
    ('\x256C', ["\x253C",   "|"]),
    ('\x256D', ["\x250C",   "."]),
    ('\x256E', ["\x2510",   "."]),
    ('\x256F', ["\x2518",   "'"]),
    ('\x2570', ["\x2514",   "`"]),
    ('\x2571', ["/"]),
    ('\x2572', ["\\"]),
    ('\x2573', ["X"]),
    ('\x2574', ["\x2500",   "-"]),
    ('\x2575', ["\x2502",   "'"]),
    ('\x2576', ["\x2500",   "-"]),
    ('\x2577', ["\x2502",   "."]),
    ('\x2578', ["\x2550",   "\x2500",   "="]),
    ('\x2579', ["\x2551",   "\x2502",   "'"]),
    ('\x257A', ["\x2550",   "\x2500",   "="]),
    ('\x257B', ["\x2551",   "\x2502",   "."]),
    ('\x257C', ["\x2500",   "-"]),
    ('\x257D', ["\x2502",   "|"]),
    ('\x257E', ["\x2500",   "-"]),
    ('\x257F', ["\x2502",   "|"]),
    ('\x2580', ["\x2588",   "\""]),
    ('\x2581', ["_"]),
    ('\x2582', ["_"]),
    ('\x2583', ["\x2584",   "_"]),
    ('\x2584', ["\x2588",   "_"]),
    ('\x2585', ["\x2584",   "\x2588",   "_"]),
    ('\x2586', ["\x2588",   "#"]),
    ('\x2587', ["\x2588",   "#"]),
    ('\x2588', ["#"]),
    ('\x2589', ["\x2588",   "#"]),
    ('\x258A', ["\x2588",   "#"]),
    ('\x258B', ["\x258C",   "\x2588",   "["]),
    ('\x258C', ["\x2588",   "["]),
    ('\x258D', ["\x258C",   "["]),
    ('\x258E', [" "]),
    ('\x258F', [" "]),
    ('\x2590', ["\x2588",   "]"]),
    ('\x2591', ["\x2592",   "#"]),
    ('\x2592', ["\x2588",   "#"]),
    ('\x2593', ["\x2592",   "\x2588",   "#"]),
    ('\x2594', ["\""]),
    ('\x2595', [" "]),
    ('\x25A0', ["#"]),
    ('\x25AC', ["\x25A0",   "#"]),
    ('\x25B2', ["\x25B4",   "^"]),
    ('\x25B4', ["\x25B2",   "^"]),
    ('\x25B6', ["\x25B8",   "\x25BA",   ">"]),
    ('\x25B8', ["\x25B6",   "\x25BA",   ">"]),
    ('\x25BA', ["\x25B6",   "\x25B8",   ">"]),
    ('\x25BC', ["\x25BE",   "v"]),
    ('\x25BE', ["\x25BC",   "v"]),
    ('\x25C0', ["\x25C2",   "\x25C4",   "<"]),
    ('\x25C2', ["\x25C0",   "\x25C4",   "<"]),
    ('\x25C4', ["\x25C0",   "\x25C2",   "<"]),
    ('\x25CA', ["\x2662",   "\x2666",   "<>"]),
    ('\x25CB', ["*"]),
    ('\x25D8', ["*"]),
    ('\x25D9', ["*"]),
    ('\x25E2', ["/"]),
    ('\x25E3', ["\\"]),
    ('\x260E', ["TEL"]),
    ('\x260F', ["tel"]),
    ('\x2610', ["[ ]",      " "]),
    ('\x2611', ["[\x221A]", "[x]",      "x"]),
    ('\x2612', ["[x]",      "x"]),
    ('\x2613', ["\xD7",     "x"]),
    ('\x263A', [":-)"]),
    ('\x263B', ["(-:"]),
    ('\x263C', ["*"]),
    ('\x2640', ["o-+",      "f"]),
    ('\x2642', ["o->",      "m"]),
    ('\x2660', ["\x2664",   "[SPADE]",  "S"]),
    ('\x2661', ["\x2665",   "[HEART]",  "H"]),
    ('\x2662', ["\x2666",   "[DIAMOND]", "D"]),
    ('\x2663', ["\x2667",   "[CLUB]",   "C"]),
    ('\x2664', ["\x2660",   "[SPADE]",  "S"]),
    ('\x2665', ["\x2661",   "[HEART]",  "H"]),
    ('\x2666', ["\x2662",   "[DIAMOND]", "D"]),
    ('\x2667', ["\x2663",   "[CLUB]",   "C"]),
    ('\x2669', ["[MUSIC]"]),
    ('\x266A', ["[MUSIC]"]),
    ('\x266B', ["[MUSIC]"]),
    ('\x266C', ["[MUSIC]"]),
    ('\x266D', ["b"]),
    ('\x266E', ["Mx"]),
    ('\x266F', ["#"]),
    ('\x3012', ["=T"]),
    ('\x3020', ["=T:)"]),
    ('\x3041', ["a"]),
    ('\x3042', ["a"]),
    ('\x3043', ["i"]),
    ('\x3044', ["i"]),
    ('\x3045', ["u"]),
    ('\x3046', ["u"]),
    ('\x3047', ["e"]),
    ('\x3048', ["e"]),
    ('\x3049', ["o"]),
    ('\x304A', ["o"]),
    ('\x304B', ["ka"]),
    ('\x304C', ["ga"]),
    ('\x304D', ["ki"]),
    ('\x304E', ["gi"]),
    ('\x304F', ["ku"]),
    ('\x3050', ["gu"]),
    ('\x3051', ["ke"]),
    ('\x3052', ["ge"]),
    ('\x3053', ["ko"]),
    ('\x3054', ["go"]),
    ('\x3055', ["sa"]),
    ('\x3056', ["za"]),
    ('\x3057', ["shi"]),
    ('\x3058', ["ji"]),
    ('\x3059', ["su"]),
    ('\x305A', ["zu"]),
    ('\x305B', ["se"]),
    ('\x305C', ["ze"]),
    ('\x305D', ["so"]),
    ('\x305E', ["zo"]),
    ('\x305F', ["ta"]),
    ('\x3060', ["da"]),
    ('\x3061', ["chi"]),
    ('\x3062', ["ji"]),
    ('\x3063', ["tsu"]),
    ('\x3064', ["tsu"]),
    ('\x3065', ["zu"]),
    ('\x3066', ["te"]),
    ('\x3067', ["de"]),
    ('\x3068', ["to"]),
    ('\x3069', ["do"]),
    ('\x306A', ["na"]),
    ('\x306B', ["ni"]),
    ('\x306C', ["nu"]),
    ('\x306D', ["ne"]),
    ('\x306E', ["no"]),
    ('\x306F', ["ha"]),
    ('\x3070', ["ba"]),
    ('\x3071', ["pa"]),
    ('\x3072', ["hi"]),
    ('\x3073', ["bi"]),
    ('\x3074', ["pi"]),
    ('\x3075', ["fu"]),
    ('\x3076', ["bu"]),
    ('\x3077', ["pu"]),
    ('\x3078', ["he"]),
    ('\x3079', ["be"]),
    ('\x307A', ["pe"]),
    ('\x307B', ["ho"]),
    ('\x307C', ["bo"]),
    ('\x307D', ["po"]),
    ('\x307E', ["ma"]),
    ('\x307F', ["mi"]),
    ('\x3080', ["mu"]),
    ('\x3081', ["me"]),
    ('\x3082', ["mo"]),
    ('\x3083', ["ya"]),
    ('\x3084', ["ya"]),
    ('\x3085', ["yu"]),
    ('\x3086', ["yu"]),
    ('\x3087', ["yo"]),
    ('\x3088', ["yo"]),
    ('\x3089', ["ra"]),
    ('\x308A', ["ri"]),
    ('\x308B', ["ru"]),
    ('\x308C', ["re"]),
    ('\x308D', ["ro"]),
    ('\x308E', ["wa"]),
    ('\x308F', ["wa"]),
    ('\x3090', ["wi"]),
    ('\x3091', ["we"]),
    ('\x3092', ["wo"]),
    ('\x3093', ["n"]),
    ('\x3094', ["vu"]),
    ('\x30A1', ["a"]),
    ('\x30A2', ["a"]),
    ('\x30A3', ["i"]),
    ('\x30A4', ["i"]),
    ('\x30A5', ["u"]),
    ('\x30A6', ["u"]),
    ('\x30A7', ["e"]),
    ('\x30A8', ["e"]),
    ('\x30A9', ["o"]),
    ('\x30AA', ["o"]),
    ('\x30AB', ["ka"]),
    ('\x30AC', ["ga"]),
    ('\x30AD', ["ki"]),
    ('\x30AE', ["gi"]),
    ('\x30AF', ["ku"]),
    ('\x30B0', ["gu"]),
    ('\x30B1', ["ke"]),
    ('\x30B2', ["ge"]),
    ('\x30B3', ["ko"]),
    ('\x30B4', ["go"]),
    ('\x30B5', ["sa"]),
    ('\x30B6', ["za"]),
    ('\x30B7', ["shi"]),
    ('\x30B8', ["ji"]),
    ('\x30B9', ["su"]),
    ('\x30BA', ["zu"]),
    ('\x30BB', ["se"]),
    ('\x30BC', ["ze"]),
    ('\x30BD', ["so"]),
    ('\x30BE', ["zo"]),
    ('\x30BF', ["ta"]),
    ('\x30C0', ["da"]),
    ('\x30C1', ["chi"]),
    ('\x30C2', ["ji"]),
    ('\x30C3', ["tsu"]),
    ('\x30C4', ["tsu"]),
    ('\x30C5', ["zu"]),
    ('\x30C6', ["te"]),
    ('\x30C7', ["de"]),
    ('\x30C8', ["to"]),
    ('\x30C9', ["do"]),
    ('\x30CA', ["na"]),
    ('\x30CB', ["ni"]),
    ('\x30CC', ["nu"]),
    ('\x30CD', ["ne"]),
    ('\x30CE', ["no"]),
    ('\x30CF', ["ha"]),
    ('\x30D0', ["ba"]),
    ('\x30D1', ["pa"]),
    ('\x30D2', ["hi"]),
    ('\x30D3', ["bi"]),
    ('\x30D4', ["pi"]),
    ('\x30D5', ["fu"]),
    ('\x30D6', ["bu"]),
    ('\x30D7', ["pu"]),
    ('\x30D8', ["he"]),
    ('\x30D9', ["be"]),
    ('\x30DA', ["pe"]),
    ('\x30DB', ["ho"]),
    ('\x30DC', ["bo"]),
    ('\x30DD', ["po"]),
    ('\x30DE', ["ma"]),
    ('\x30DF', ["mi"]),
    ('\x30E0', ["mu"]),
    ('\x30E1', ["me"]),
    ('\x30E2', ["mo"]),
    ('\x30E3', ["ya"]),
    ('\x30E4', ["ya"]),
    ('\x30E5', ["yu"]),
    ('\x30E6', ["yu"]),
    ('\x30E7', ["yo"]),
    ('\x30E8', ["yo"]),
    ('\x30E9', ["ra"]),
    ('\x30EA', ["ri"]),
    ('\x30EB', ["ru"]),
    ('\x30EC', ["re"]),
    ('\x30ED', ["ro"]),
    ('\x30EE', ["wa"]),
    ('\x30EF', ["wa"]),
    ('\x30F0', ["wi"]),
    ('\x30F1', ["we"]),
    ('\x30F2', ["wo"]),
    ('\x30F3', ["n"]),
    ('\x30F4', ["vu"]),
    ('\x30F5', ["ka"]),
    ('\x30F6', ["ke"]),
    ('\x30F7', ["va"]),
    ('\x30F8', ["vi"]),
    ('\x30F9', ["ve"]),
    ('\x30FA', ["vo"]),
    ('\xFB00', ["ff"]),
    ('\xFB01', ["fi"]),
    ('\xFB02', ["fl"]),
    ('\xFB03', ["ffi"]),
    ('\xFB04', ["ffl"]),
    ('\xFB05', ["St"]),
    ('\xFB06', ["st"]),
    ('\xFFFD', ["\x25A0",   "?"])]

bulgarian :: FiniteMap Char [String]
bulgarian = addListToFM generic [
    ('\x429', ["SHT", "SHCH", "\x15C", "\x160", "S"]),
    ('\x42A', ["Y",   "\""]),
    ('\x449', ["sht", "shch", "\x15D", "\x161", "s"]),
    ('\x44A', ["y",   "\""])]

croatian :: FiniteMap Char [String]
croatian = addListToFM generic [
    ('\x110', ["\xD0", "DJ", "D"]),
    ('\x111', ["dj",   "d"])]

german :: FiniteMap Char [String]
german = addListToFM generic [
    ('\xC4', ["AE", "A"]),
    ('\xD6', ["OE", "O"]),
    ('\xDC', ["UE", "U"]),
    ('\xE4', ["ae", "a"]),
    ('\xF6', ["oe", "o"]),
    ('\xFC', ["ue", "u"])]

ukrainian :: FiniteMap Char [String]
ukrainian = addListToFM generic [
    ('\x418', ["Y", "I"]),
    ('\x438', ["y", "i"])]

vietnamese :: FiniteMap Char [String]
vietnamese = addListToFM generic [
    ('\xC0',  ["A`",   "A"]),
    ('\xC1',  ["A'",   "A"]),
    ('\xC2',  ["A^",   "A"]),
    ('\xC3',  ["A~",   "A"]),
    ('\xC8',  ["E`",   "E"]),
    ('\xC9',  ["E'",   "E"]),
    ('\xCA',  ["E^",   "E"]),
    ('\xCC',  ["I`",   "I"]),
    ('\xCD',  ["I'",   "I"]),
    ('\xD2',  ["O`",   "O"]),
    ('\xD3',  ["O'",   "O"]),
    ('\xD4',  ["O^",   "O"]),
    ('\xD5',  ["O~",   "O"]),
    ('\xD9',  ["U`",   "U"]),
    ('\xDA',  ["U'",   "U"]),
    ('\xDD',  ["Y'",   "Y"]),
    ('\xE0',  ["a`",   "a"]),
    ('\xE1',  ["a'",   "a"]),
    ('\xE2',  ["a^",   "a"]),
    ('\xE3',  ["a~",   "a"]),
    ('\xE8',  ["e`",   "e"]),
    ('\xE9',  ["e'",   "e"]),
    ('\xEA',  ["e^",   "e"]),
    ('\xEC',  ["i`",   "i"]),
    ('\xED',  ["i'",   "i"]),
    ('\xF2',  ["o`",   "o"]),
    ('\xF3',  ["o'",   "o"]),
    ('\xF4',  ["o^",   "o"]),
    ('\xF5',  ["o~",   "o"]),
    ('\xF9',  ["u`",   "u"]),
    ('\xFA',  ["u'",   "u"]),
    ('\xFD',  ["y'",   "y"]),
    ('\x102', ["A(",   "A"]),
    ('\x103', ["a(",   "a"]),
    ('\x110', ["\xD0", "DD", "D"]),
    ('\x111', ["dd",   "d"]),
    ('\x128', ["I~",   "I"]),
    ('\x129', ["i~",   "i"]),
    ('\x168', ["U~",   "U"]),
    ('\x169', ["u~",   "u"])]
