(defun pld-devel-preamble () "Insert PLD-style package-devel Preamble" 
  (interactive) 
  (save-restriction
    (save-excursion
      (insert "%package devel\n")
      (insert "Summary:	%{name} header files\n")
      (insert "Summary(pl):	Pliki nagwkowe %{name}\n")
      (insert "Group:		Development/Libraries\n")
      (insert "Group(fr):	Development/Librairies\n")
      (insert "Group(pl):	Programowanie/Biblioteki\n")
      (insert "Requires:	%{name} = %{version}\n\n")
      (insert "%description devel\n")
      (insert "%{name} header files.\n\n")
      (insert "%description -l pl devel\n")
      (insert "Pliki nagwkowe %{name}.\n")

      )))


(defun pld-static-preamble () "Insert PLD-style package-static Preamble" 
  (interactive) 
  (save-restriction
    (save-excursion
      (insert "%package static\n")
      (insert "Summary:	Static %{name} libraries\n")
      (insert "Summary(pl):	Biblioteki statyczne %{name}\n")
      (insert "Group:		Development/Libraries\n")
      (insert "Group(fr):	Development/Librairies\n")
      (insert "Group(pl):	Programowanie/Biblioteki\n")
      (insert "Requires:	%{name}-devel = %{version}\n\n")
      (insert "%description static\n")
      (insert "Static %{name} libraries.\n\n")
      (insert "%description -l pl static\n")
      (insert "Biblioteki statyczne %{name}.\n")
      )))
