(setq sgml-set-face t)

(defun sgml-wstaw-para ()
  (interactive "*")
  (if (region-active-p) 
      (sgml-tag-region "para" (region-beginning) (region-end)) (sgml-insert-element "para")))
(defun sgml-wstaw-literal ()
  (interactive "*")
  (if (region-active-p) 
      (sgml-tag-region "literal" (region-beginning) (region-end)) (sgml-insert-element "literal")))
(defun sgml-wstaw-emphasis ()
  (interactive "*")
  (if (region-active-p) 
      (sgml-tag-region "emphasis" (region-beginning) (region-end)) (sgml-insert-element "emphasis")))
(defun sgml-wstaw-keycap ()
  (interactive "*")
  (if (region-active-p) 
      (sgml-tag-region "keycap" (region-beginning) (region-end)) (sgml-insert-element "keycap")))
(defun sgml-wstaw-command ()
  (interactive "*")
  (if (region-active-p) 
      (sgml-tag-region "command" (region-beginning) (region-end)) (sgml-insert-element "command")))
(defun sgml-wstaw-filename ()
  (interactive "*")
  (if (region-active-p) 
      (sgml-tag-region "filename" (region-beginning) (region-end)) (sgml-insert-element "filename")))

(defun sgml-wstaw-itemizedlist ()
  (interactive "*")
  (sgml-insert-element "itemizedlist")
)

(defun sgml-wstaw-orderedlist ()
  (interactive "*")
  (sgml-insert-element "orderedlist"))

(defun sgml-wstaw-literallayout ()
  (interactive "*")
  (sgml-insert-element "literallayout"))

(defun sgml-zmie-na-encje () "zamienia & i < na encje"
  (save-excursion
    (replace-string "<" "&lt;")
    (replace-string "&" "&amp;")
))


(defun sgml-wstaw-lt () "wstawia &lt;"
  (interactive "_")
  (if (region-active-p) 
      (replace-string "<" "&lt;") (insert-string "&lt;")))

(defun sgml-wstaw-amp () "wstawia &amp;"
  (interactive "_")
  (if (region-active-p) 
      (replace-string "&" "&amp;") (insert-string "&amp;")))

(add-hook 'sgml-mode-hook
	  '(lambda()
	     (setq sgml-auto-insert-required-elements t)
	     (setq sgml-omittag-transparent t)
	     (setq sgml-tag-region-if-active t)
	     (line-number-mode t)
	     (font-lock-mode)

	     (local-set-key [(meta p)] 'sgml-wstaw-para)
	     (local-set-key [(meta l)] 'sgml-wstaw-literal)
	     (local-set-key [(meta e)] 'sgml-wstaw-emphasis)
	     (local-set-key [(meta k)] 'sgml-wstaw-keycap)
	     (local-set-key [(meta f)] 'sgml-wstaw-filename)
	     (local-set-key [(meta c)] 'sgml-wstaw-command)
	     (local-set-key [(meta <)] 'sgml-wstaw-lt)
	     (local-set-key [(meta &)] 'sgml-wstaw-amp)
	     (local-set-key [(control meta i)] 'sgml-wstaw-itemizedlist)
	     (local-set-key [(control meta o)] 'sgml-wstaw-orderedlist)
	     (local-set-key [(control meta l)] 'sgml-wstaw-literallayout)

	     (local-set-key [(iso-left-tab)] 'sgml-indent-or-tab)
	     (local-set-key [(tab)] 'sgml-complete)
	     (local-set-key [(return)] 'reindent-then-newline-and-indent)
	     (local-set-key [(control return)] 'sgml-split-element)
	     (setq sgml-indent-data t)
	     
	     (setq sgml-markup-faces 
		   '((start-tag . font-lock-comment-face)
		     (end-tag . font-lock-type-face)
		     (comment . font-lock-string-face)
		     (pi . italic)
		     (sgml . italic)
		     (doctype . font-lock-reference-face)
		     (entity . font-lock-keyword-face)
		     (shortref . green)))



	     ))


