/* $Id: n_list_lookup_ex.c,v 1.1 2000/10/29 21:12:21 mis Exp $ */

#include "n_list_int.h"

void *n_list_lookup_ex(const tn_list *l, const void *data, t_fn_cmp cmpf)
{
    register struct list_node *node;


    if (cmpf == NULL)
	cmpf = l->cmp_fn;

    if (cmpf == NULL) {
	trurl_die("n_list_lookup: cmpf function is NULL\n");
	return NULL;
    }
    
    for (node = l->head; node != NULL; node = node->next) {
	if (cmpf(node->data, data) == 0)
	    return node->data;
    }

    return NULL;
}
