/* $Id: var.c,v 1.6 2000/05/15 11:26:49 malekith Exp $ */
#include "h.h"

struct magic_var {
	const char *name;
	int type;
	void *ptr;
};

#define MAGIC_INT	1
#define MAGIC_STR	2
#define MAGIC_FUN	3

extern long	sec_start;	/* $SECONDS */

extern char **positional;

static char *get_name()
{
	/* TODO: fix to ret command name, func name */
	if (script)
		return script;
	else
		return our_name;
}

static char *get_sec()
{
	return sprintf("%d", xtime() - sec_start);
}

static char *get_rand()
{
	return sprintf("%u", rand());
}

extern int our_pid, our_ppid, last_bg_pid, line;
extern char oldpwd[];

static char *get_npos()
{
	int i = 0;
	char **p = positional;
	
	while (*p++) i++;
	return sprintf("%d", --i);
}

struct magic_var mvars[] = {
	{ "!",		MAGIC_INT, &last_bg_pid },
	{ "$",		MAGIC_INT, &our_pid },
	{ "?",		MAGIC_INT, &last_exit },
	{ "0",		MAGIC_FUN, get_name },
	{ "LINENO",	MAGIC_INT, &line },
	{ "OLDPWD",	MAGIC_STR, oldpwd },
	{ "PPID",	MAGIC_INT, &our_ppid },
	{ "PWD",	MAGIC_FUN, cwd },
	{ "RANDOM",	MAGIC_FUN, get_rand },
	{ "SECONDS",	MAGIC_FUN, get_sec },
	{ "#",		MAGIC_FUN, get_npos },
/*	{ "-",		MAGIC_BAD, 0 }, -- TODO: do it ;) */
/*	{ "@",		MAGIC_BAD, 0 }, 
	{ "*",		MAGIC_BAD, 0 }, -- alrady handled */
	{ 0, 0, 0 }
};

static char *pattern_var(char *var, int beg, int longest, char *pat)
{
	char *p, *ret;

	ret = strdup(var);

	if (match_start(pat)) {
		perr("%s: bad pattern in substitution", pat);
		return 0;
	}

	if (beg) {
		char *p2;

		if (longest)
			for (p2 = strchr(var, 0), p = strchr(ret, 0);
			     p >= ret; p--, p2--) {
				*p = 0;
				if (match(ret))
					break;
		} else
			for (p2 = var, p = ret; *p2; p2++, p++) {
				*p = 0;
				if (match(ret))
					break;
				*p = *p2;
			}
		ret = p2;
	} else {
		if (longest) {
			for (p = ret; *p; p++)
				if (match(p))
					break;
		} else {
			for (p = strchr(ret, 0); p >= ret; p--)
				if (match(p))
					break;
		}
		*p = 0;
	}

	match_free();

	return ret;
}

static char *check_mod(char *name, char *var, char *rest, int len)
{
	int var_ok, c;
	
	if (len && rest) {
		perr("%s: bad substitution", rest);
		return 0;
	}
	
	if (len)
		var = sprintf("%d", var ? strlen(var) : 0);
		
	if (rest == 0)
		return var ? var : "";
		
	if (*rest == ':')
		rest++, var_ok = var && *var;
	else
		var_ok = var != 0;
		
	c = *rest++;
	
	switch (c) {
	case '-':
		if (var_ok) return var;
		return nested_expand(rest);
	case '+':
		if (var_ok) return nested_expand(rest);
		return "";
	case '=':
		if (var_ok) return var;
		putenv_f(name, nested_expand(rest), 0); 
		return getenv(name);
	case '?':
		if (var_ok) return var;
		perr("%s: %s", name, nested_expand(rest));
		error_lev = 1;
		return 0;
	case '#':
	case '%':
		if (var == 0 || *var == 0) return "";
		if (*rest == c)
			return pattern_var(var, c == '#', 1, ++rest);
		else
			return pattern_var(var, c == '#', 0, rest);
	default:
		perr("%s: bad substitution", rest - 1);
		return 0;
	}
}

char *interpret_var(char *name)
{
	char *ret = 0, *p, *rest = 0;
	struct magic_var *mp;
	int len = 0;

	if (*name == '#') {
		if (strchr("@*", name[1]))
			name[1] = 0;	/* change into $# */
		else {
			len = 1;
			name++;
		}
	}

	for (p = name; *p; p++)
		if (!isalnum(*p)) {
			rest = strdup(p);
			*p = 0;
			break;
		}

	if (atoi(name)) {
		int i = 0;
		char **p = positional;
		while (*p++)
			i++;
		if (atoi(name) < i)
			ret = positional[atoi(name)];
		else
			ret = 0;
	} else {
		for (mp = mvars; ret == 0 && mp->name; mp++)
			if (strcmp(mp->name, name) == 0)
				switch (mp->type) {
				case MAGIC_INT:
					ret = sprintf("%d", *(int *) mp->ptr);
					break;
				case MAGIC_STR:
					ret = sprintf("%s", (char *) mp->ptr);
					break;
				case MAGIC_FUN:
					/* typedefs suxx !!! ;) */
					ret = ((char *(*)(void)) mp->ptr)();
					break;
				}

		if (!ret)
			ret = getenv(name);
	}
	return check_mod(name, ret, rest, len);
}
