/* $Id: trash.c,v 1.26 2000/05/15 16:45:56 malekith Exp $ */

#include "h.h"

#include <asm/signal.h>
 
#define _SYS_IOCTL_H
#include <bits/ioctls.h>
#include <bits/ioctl-types.h>

int isatty;
int interupt;
extern char *prompt;
char **argv;
int argc;
char *our_name;		/* $0 */
char *script;		/* $0 */
int line;		/* $LINENO */
int last_exit;		/* $? */
int our_pid;		/* $$ */
int our_ppid;		/* $PPID */
long sec_start;		/* $SECONDS */

char **positional;

extern char *xversion, *xdate;

void sighandler(int sig)
{
	if (sig != SIGCHLD)
		return;
		
	wait4(-1,0,0,0);
}

void block_child(int doblock)
{
	struct sigaction s;
	static int child_blocked = 1;

	if (doblock) {
		if (child_blocked++)		/* was blocked */
			return;
	} else {
		if (--child_blocked)		/* is still blocked */
			return;
	}
	
	sigaction(SIGCHLD,0,&s);
	if (child_blocked)
		s.sa_handler = SIG_DFL;
	else
		s.sa_handler = sighandler;
	s.sa_flags = SA_NOCLDSTOP;
	sigaction(SIGCHLD,&s,0);
}

static void int_handler(int no)
{
	struct sigaction s;
		
	interupt = 1;
	
	sigaction(no,0,&s);
	s.sa_handler = int_handler;
	sigaction(no,&s,0);
}

void init_tty()
{
	struct termio t;
	
	if (ioctl(0, TCGETA, &t) == 0) {
		isatty=1;
		printf("welcome to trash mk ][  / v%s [ %s ]\n", xversion, xdate);
		if (getuid())
			prompt = "[36mtrash[1m@[0m ";
		else
			prompt = "trash# ";
	}
	
	if (isatty) {
		int_handler(SIGINT);
		interupt = 0;
		block_child(0);	/* unblock sigchild */
	}
}

void init()
{
	alloc_init();
	setupenv();
	
	our_pid = getpid();
	our_ppid = getppid();
	sec_start = xtime();
}

void do_script(char **argv);

int main(int argc, char **argv)
{
	our_name = *argv++;
	(void)argc;
	
	init();
	
	if (*argv == 0) { }
	else if (strcmp(*argv, "-c") == 0) {
		if (*++argv)
			exec(strdup(*argv), 1);
			/* never returns */
		else {
			perr("-c: requires parameter");
			exit(1);
		}
	} else if (strcmp(*argv, "-s") == 0) {
		argv++;
	} else if (**argv == '-') {
		perr("%s: unknown option",*argv);
		exit(1);
	} else {
		do_script(argv);
		/* never returns */
	}
	
	init_tty();
	
	positional = argv - 1;
		
	/* main loop */
	{
		char *p;
		
		while ((p = getline(0)) && error_lev == 0) {
			exec(p, 0);
			/* clear errors in interactive shells */
			if (isatty)
				error_lev = 0;	
		}
	}
	
	return last_exit;
}
