/* $Id: string.c,v 1.5 2000/05/08 11:50:30 malekith Exp $ */

#include "h.h"

#ifndef __HAVE_ARCH_STRLEN
unsigned int strlen(const char *p)
{
	const char *pp;
	pp = p;
	while (*pp)
		pp++;
	return pp - p;
}
#endif

#ifndef __HAVE_ARCH_MEMCPY
void *memcpy(void *p, const void *s, size_t n)
{
	char *pp;
	const char *ss;
	
	if (n == 0) return p;
	pp = p;
	ss = s;
	
	while (n--)
		*pp++ = *ss++;
	return p;
}
#endif

#ifndef __HAVE_ARCH_STRNCMP
int strncmp(const char *a, const char *b, size_t p)
{
	if (p == 0)
		return 0;
		
	while (*a && *a == *b && p--)
		a++, b++;
	if (*a == *b || p == 0)
		return 0;
	if (*a < *b)
		return -1;
	else
		return +1;
}
#endif

#ifndef __HAVE_ARCH_STRCMP
int strcmp(const char *a, const char *b)
{
	while (*a && *a == *b)
		a++, b++;
	if (*a == *b)
		return 0;
	if (*a < *b)
		return -1;
	else
		return +1;
}
#endif

#ifndef __HAVE_ARCH_STRCHR
char *strchr(const char *p, int c)
{
	if (c == 0) {
		while (*p)
			p++;
		return (char*)p;
	}
	while (*p && *p != c)
		p++;
	if (*p)
		return (char*)p;
	else
		return 0;
}
#endif

#ifndef __HAVE_ARCH_STRCPY
char *strcpy(char *d, const char *s)
{
	char *p = d;
	while (*s)
		*p++ = *s++;
	*p = 0;
	return d;
}
#endif

#ifndef __HAVE_ARCH_STRNCPY
char *strncpy(char *d, const char *s, size_t n)
{
	char *p = d;
	
	if (n == 0)
		return d;
	n--;
	do {
		*p++ = *s;
	} while (*s++ && n--);
	
	return d;
}
#endif

#ifndef __HAVE_ARCH_MEMMOVE
/* stolen from linux kernel */
void *memmove(void *dest, const void *src, size_t count)
{
	char *tmp, *s;

	if (dest <= src) {
		tmp = (char *) dest;
		s = (char *) src;
		while (count--)
			*tmp++ = *s++;
	} else {
		tmp = (char *) dest + count;
		s = (char *) src + count;
		while (count--)
			*--tmp = *--s;
	}

	return dest;
}
#endif

#ifndef __HAVE_ARCH_MEMSET
void *memset(void *d, int c, size_t n)
{
	unsigned char *p;

	if (n == 0)
		return d;
		
	p = d;
		
	while (n--)
		*p++ = c;
		
	return d;		
}
#endif
