/* $Id: line-eaters.c,v 1.5 2000/05/13 22:34:49 malekith Exp $ */
#include "h.h"

char *cont_prompt = "> ";
char *prompt;

static char *gl_buf, *gl_ptr;
static int gl_len;
static int gl_fd = 0;
static int gl_lev = 0;

int gl_eof;
extern int line, interupt;

void gl_push(int fd)
{
	a_push_val(a_gl, gl_buf);
	a_push_val(a_gl, gl_ptr);
	a_push_val(a_gl, gl_len);
	a_push_val(a_gl, gl_fd);
	a_push_val(a_gl, gl_eof);
	a_push_val(a_gl, line);
	a_push_state(a_gl);
	gl_buf = gl_ptr = 0;
	gl_len = gl_eof = 0;
	gl_fd = fd;
	line = 0;
	gl_lev++;
}

void gl_pop()
{
	a_pop_state(a_gl);
	a_pop_val(a_gl, line);
	a_pop_val(a_gl, gl_eof);
	a_pop_val(a_gl, gl_fd);
	a_pop_val(a_gl, gl_len);
	a_pop_val(a_gl, gl_ptr);
	a_pop_val(a_gl, gl_buf);
	gl_lev--;
}

#define CHUNK 512
char *getline(int cont)
{
	int r;
	char *p, *ret;
	
	if (gl_eof)
		return 0;
		
	/* initialize if needed */
	if (!gl_buf)
		gl_ptr = gl_buf = a_alloc(a_gl, gl_len = 32 + CHUNK);
		
	/* print prompt if desired */
	if (isatty && gl_lev == 0)
		puts(cont ? cont_prompt : prompt);

	/* TODO: fix this ugly cross jumps */
			
	if (gl_ptr != gl_buf)
		goto find_end;
	
read_again:
	interupt = 0;
	r = read(gl_fd, gl_ptr, CHUNK);
	if (interupt) {
		gl_ptr = gl_buf;
		printf("\n");
		return cont ? 0 : strdup("");
	}
	if (r <= 0 && errno == EINTR)
		goto read_again;

	if (r <= 0) {
		/* do the last line */
		if (gl_ptr != gl_buf) {
			*gl_ptr = 0;
			gl_ptr = gl_buf;
			gl_eof = 1;
			return strdup(gl_buf);
		}
		/* no last line ... */
		gl_eof = 1;
		return 0;
	}

	gl_ptr[r] = 0;

find_end:	
	/* find unquoted newline */
	if (*(p = gl_buf) != '\n')
		for (; *p; p++) {
			if (*p != '\\' && p[1] == '\n')
				break;
			if (*p == '\n')
				line++;
		}
	
	if (!*p) {	/* no newline, read on */
		gl_ptr = p;
		if (gl_ptr - gl_buf + CHUNK > gl_len) {
			a_alloc(a_gl, CHUNK);
			gl_len += CHUNK;
		}
		
		p -= 2;
		if (isatty && p[0] == '\\' && p[1] == '\n')
			puts(cont_prompt);
			
		goto read_again;
	}
	
	line++;
		
	if (*gl_buf != '\n')
		p++;
	p++;
	
	ret = strndup(gl_buf, p - gl_buf);
	
	if (*p) {
		/* we have typeahead */
		r = strlen(p);
		memmove(gl_buf, p, r);
		gl_buf[r] = 0;
		gl_ptr = gl_buf + r;
		if (r + CHUNK > gl_len) {
			a_alloc(a_gl, CHUNK);
			gl_len += CHUNK;
		}
	} else
		gl_ptr = gl_buf;

WIZARD(64, "gl: '%s'\n", ret);
	return ret;
}
