/* $Id: xsyscall.h,v 1.6 2000/05/15 11:26:49 malekith Exp $ */

/* syscall.c */
extern int errno;
extern char **environ;

struct rusage;

int write(int fd, const void *buf, int count);
int read(int fd, void *buf, int count);
int ioctl(int fd, int req, void *buf);
void *brk(void *end);
int getuid(void);
int fork(void);
pid_t wait4(pid_t pid, int *wait_stat, int options, struct rusage *rusage);
int execve(const char *file, char **argv, char **envp);
int close(int fd);
int open(const char *name, int xx, int mode);
int chdir(char *f);
void exit(int x);
void *mmap(void *start, size_t length, int prot, int flags, int fd, off_t offset);
int munmap(void *start, size_t length);
void * mremap(void * old_address, size_t old_size , size_t new_size, unsigned long flags);
int getcwd(char*,int); /* linux rulez ! */
int kill(pid_t pid, int sig);
pid_t getpid(void);
pid_t getppid(void);
int pipe(int *fd);
int fcntl(int fd, int cmd, long arg);
int dup2(int oldfd, int newfd);
struct sigaction;
int sigaction(int signum, const struct sigaction *act,
	      struct sigaction *oldact);
/* implemented using gettimeofday() for y2038 comp. on 64 bit machines ;) */
long xtime(void);

/* defines ... */
#define O_RDONLY             00
#define O_WRONLY             01
#define O_RDWR               02
#define O_CREAT            0100
#define O_EXCL             0200
#define O_TRUNC           01000
#define O_APPEND          02000

#define F_DUPFD         0
#define F_SETFD         2
#define FD_CLOEXEC      1

#define WNOHANG		1
