/* $Id: parser.h,v 1.10 2000/05/15 11:26:49 malekith Exp $ */

/* used by parser.c, executor.c, control.c */


struct control;
struct arg {
	struct arg *next;
	int redir_fd;	/* if not -1, val gives target */
	int target_fd;	/* unless this isn't -1 */
	int flags;	/* for redir's open() */
	int terminator;
	int type;
	struct control *ctl;
	char val[0];
};

struct arg *skip_command(struct arg *head);
int find_control(struct arg *head);	/* 1 if found, 0 otherwise */
struct arg *ctl_find_end(struct arg *head);
void ctl_exec(struct arg *head);

/* for arg->type */
#define T_NORMAL	1	/* regular arg */
#define T_ASSIGN	2	/* it's NAME=value item */
#define T_REDIR		3	/* 2>&1 or something */
#define T_TERMINATOR	4	/* '|','&',';','\n' */

/* we call it recurs. in case of `` */
void exec(const char *p, int dont_fork); 
struct arg *parse(const char *p);
int issep(int c);
char *nested_expand(char *xxx);


extern int gl_eof; 	/* used to block expand()/parse()/exec() from getting
			 * more input */
	
