/* $Id: h.h,v 1.21 2000/05/15 11:26:49 malekith Exp $ */

#ifndef _H_H
#define _H_H

#include "config.h"

#include <sys/types.h>
#include <asm/errno.h>

#if defined(USE_INLINE_STRINGS) && defined(linux)
#	include <linux/string.h>
#	define INLINE_STRING
#endif

#include "assert.h"
#include "alloc.h"
#include "parser.h"
#include "xsyscall.h"
#include "func.h"

#define get_ap(fmt) ((void*)((char*)&fmt + sizeof(fmt)))

extern char **argv;
extern int argc;
extern char *our_name, *script;
extern int 	line, 		/* line in script */
		last_exit, 	/* status of last exited command */
		isatty;		/* whatever shell is interactive */

extern int continue_lev, break_lev, loop_lev, error_lev;


void xwait(int pid);

extern int wizard_mode;

#ifdef SMALL
#	define WIZARD(x, c, args... ) \
	do { } while(0)
#else
#	define WIZARD(x, c, args... ) \
		do { \
			if (wizard_mode & x) \
				printf(c , ## args ); \
		} while (0)
#endif

#endif /* _H_H */
