/* $Id: alloc.h,v 1.3 2000/05/11 20:23:55 malekith Exp $ */

void alloc_free(void); /* free all mem from alloc() */
void *alloc(int k); /* will get freed on alloc_free() */
/* align next pointer returned by alloc(), should be called after 
 * all alloc(1) etc. while this isn't a problem on x86 it could be on
 * mc68k and possibly others */
#ifndef align
void align(void);
#endif
void alloc_init(void);

/* allocator with mmap(/dev/zero) */
struct allocator {
	int fd, ao;
	void	*mem,		/* start of seg */
		*endmem,	/* end of mmap()ed */
		*memptr;	/* logical end */
	int	size;		/* endmem - mem */
};

extern struct allocator *a_pers, *a_arg, *a_gl;

void a_destroy(struct allocator *ctx);
struct allocator *a_create(void);
void *a_alloc(struct allocator *ctx, int k);
#ifndef a_align
void a_align(struct allocator *ctx);
#endif
void a_free(struct allocator *ctx);
void a_pop_state(struct allocator *ctx);
void a_push_state(struct allocator *ctx);
void a_pop(struct allocator *ctx, void *ptr, int size);
void a_push(struct allocator *ctx, const void *ptr, int size);
#define a_pop_val(ctx, val) a_pop(ctx, &val, sizeof(val))
#define a_push_val(ctx, val) a_push(ctx, &val, sizeof(val))

#define palloc(k) a_alloc(a_pers, k)
#ifndef palign
#define palign() a_align(a_pers)
#endif
