/* $Id: control.c,v 1.8 2000/05/15 16:45:56 malekith Exp $ */
#include "h.h"

struct control {
	const char *name;
	struct arg *(*find_end)(struct arg *);
	int nargs;	/* this if for standard find_end */
	void (*exec)(struct arg *);
};

void execute(struct arg *head, int do_fork);

int continue_lev, break_lev, loop_lev, error_lev;

void ctl_exec(struct arg *head)
{
	assert(head->ctl->exec);
	gl_eof++;		/* prevent getline() from being called */
	head->ctl->exec(head);
	gl_eof--;
}

void exec_cmds(const char *p)
{
	a_push_state(a_arg);
	a_push_state(0);
	exec(p, 0);
	a_pop_state(0);
	a_pop_state(a_arg);
}

/* this is bogus find_end() for end tokens, called if such unexpected
 * token is found */
static struct arg *x_fe(struct arg *a)
{
	perr("unexpected token '%s'", a->val);
	return 0;
}

static struct arg *if_fe(struct arg *a)
{
	/* look for fi */
	for (; a; a = a->next)
		if (a->type == T_NORMAL && strcmp(a->val, "fi") == 0)
			break;
	return a;
}

static struct arg *std_fe(struct arg *a)
{
	int n;
	n = a->ctl->nargs;
	while (a && n-- > 0)
		a = a->next;
	return a;
}

struct arg *ctl_find_end(struct arg *head)
{
	head = head->ctl->find_end ? head->ctl->find_end(head) : std_fe(head);
	while (head && head->next->type == T_REDIR)
		head = head->next;
	return head;
}

static void b_exec(struct arg *head)
{
	exec_cmds(head->next->val);
}

static void if_exec(struct arg *a)
{
	for (;;) {
		if (strcmp(a->val, "else") == 0) {
			exec_cmds(a->next->val);
			break;
		} else if (strcmp(a->val, "fi") == 0) {
			last_exit = 0;
			break;
		}
		a = a->next;	   /* move from {,el}if to cond */
		exec_cmds(a->val); /* check condition */
		a = a->next;	   /* move to commands */
		if (last_exit == 0) {
			exec_cmds(a->val);
			break;
		}
		a = a->next;	/* move to next {elif,else,fi} */
	}
}

static void for_exec(struct arg *a)
{
	struct arg *items;
	char *name;
	int fl;
	
	a_push_state(a_arg);
	
	a = a->next;	/* move to index var */
	name = a->val;
	a = a->next;	/* move to list */
	
	fl = get_env_flags(name);
	if (fl == -1) 
		fl = 0;
	last_exit = 0;
	loop_lev++;
	
	for (items = parse(a->val); items; items = items->next) {
		if (items->type != T_NORMAL)
			continue;
		putenv_f(name, items->val, fl);
		exec_cmds(a->next->val);
		if (continue_lev == 1)
			continue_lev = 0;
		else if (continue_lev || break_lev || error_lev)
			break;
	}
	
	if (continue_lev)
		continue_lev--;
	if (break_lev)
		break_lev--;
	loop_lev--;
	a_pop_state(a_arg);
}

static char *unquote(char *p)
{
	char *ret, *d;
	
	if (p == 0)
		return 0;
	ret = d = alloc(2);
	while (*p)
		switch (*p) {
		case '\\':
			p++;
		default:
			alloc(1);
			*d++ = *p++;
		}
	*d = 0;
	return ret;
}

static void case_exec(struct arg *a)
{
	char *word;
	struct arg *end;
	
	a = a->next;
	word = unquote(nested_expand(a->val));
	
	a = parse(a->next->val);
	
	if (a == 0) { /* should never happen */
		last_exit = 127;
		return;
	}
	/* TODO: add check if patterns arn't multiword first */
	while (a->terminator != '\n') {
		while (a->terminator == '(' || a->terminator == ';')
			a = a->next;
		for (end = a; end; end = end->next)
			if (end->terminator == 'c' || end->terminator == '\n')
				break;
		while (a->terminator != ')') {
	WIZARD(1,"m('%s' '%s')\n",word, a->val);
			if (matches(word, a->val))
				goto hit;
			a = a->next;
			switch (a->terminator) {
			case 0:
				perr("`%s' unexpected", a->val);
				goto shit;
			case ')':
				break;
			case '|':
				a = a->next;
				break;
			case 'a':
			case 'o':
			case 'c':
				perr("`%s' unexpected", 
					a->terminator == 'a' 
						? "&&" 
						: (a->terminator == 'o' 
							? "||" 
							: ";;"));
				goto shit;
			default:
				perr("`%c' unexpected", a->terminator);
				goto shit;
			} 
		}
		if (end->terminator == '\n')
			break;
		a = end->next;
	}
	/* nothing matched */
	last_exit = 0;
	return;
hit:
	while (a->terminator != ')' && a->terminator != '\n')
		a = a->next;
	if (a->terminator == '\n') {
		perr("no commands follows pattern");
		last_exit = 127;
	} else {
		end->terminator = '\n';
		execute(a->next, 1);
	}
	return;
shit:
	last_exit = 127;
	error_lev = 1;
	return;
}

static void while_exec(struct arg *a)
{
	int until;
	int xxx = 0;
	
	until = a->val[0] == 'u';
	a = a->next;
	loop_lev++;
	
	for (;;) {
		exec_cmds(a->val);
		if (until ? last_exit == 0 : last_exit != 0)
			break;
		xxx = 1;
		exec_cmds(a->next->val);
		if (continue_lev == 1)
			continue_lev = 0;
		else if (continue_lev || break_lev || error_lev)
			break;
	}
	
	if (continue_lev)
		continue_lev--;
	if (break_lev)
		break_lev--;
	loop_lev--;
		
	if (!xxx)
		last_exit = 0;
}

static struct control ctls[] = {
	{ "{", 0, 1, b_exec },
	{ "if", if_fe, 0, if_exec },
	{ "for", 0, 3, for_exec },
	/* while and until are essentially the same : */
	{ "while", 0, 2, while_exec },
	{ "until", 0, 2, while_exec }, 
	{ "case", 0, 2, case_exec },
	/* these are meant to give parse error if met -- they ought have been
	 * remved by expand() */
	#define bogus(a) { a, x_fe, 0, 0 }
	bogus("esac"),
	bogus("}"),
	bogus("do"),
	bogus("done"),
	bogus("fi"),
	bogus("elif"),
	bogus("else"),
	bogus(0),
};

int find_control(struct arg *a)
{
	struct control *p;
	a->ctl = 0;
	if (a->type != T_NORMAL)
		return 0;
	for (p = ctls; p->name; p++)
		if (strcmp(a->val, p->name) == 0)
			break;
	if (p->name == 0)
		return 0;
	a->ctl = p;
	return 1;
}

