/* $Id: builtin.c,v 1.21 2000/10/02 21:35:29 malekith Exp $ */

#include "h.h"

static int do_bye(void)
{
	if (argv[1] && argv[1][0] == '0')
		exit(0);
	else if (argv[1] && atoi(argv[1]))
		exit(atoi(argv[1]));
	else if (argv[1]) {
		perr("%s: bad number", argv[1]);
		exit(1);
	} else
		exit(last_exit);
}

char oldpwd[PATH_MAX + 2];

static int do_cd(void)
{
	if (argv[1] == 0)
		argv[1] = getenv("HOME");
		
	if (strcmp(argv[1], "-") == 0)
		argv[1] = strdup(oldpwd);
	strcpy(oldpwd, cwd());
	if (chdir(argv[1])) {
		perror("cd: %s",argv[1]);
		return 1;
	}
	return 0;
}

extern char **positional;
void do_line(char *p);

static int execute_file(const char *name)
{
	int fd;
	char *p;
	
	fd = hopen(name, O_RDONLY, 0);
	if (fd == -1) {
		perror("%s", name);
		return -1;
	}
	
	gl_push(fd);
	
	while ((p = getline(0)) && error_lev == 0)
		exec(p, 0);
		
	gl_pop();
	
	close(fd);
	
	if (error_lev) {
		error_lev = 0;
		return -1;
	} else
		return 0;
}

void do_script(char **argv)
{
	positional = argv;
	script = *argv;
	if (execute_file(*argv))
		exit(127);
	exit(last_exit);
}

static int do_dot(void)
{
	char **bp, *bs;
	int bi;
	
	argv++;
	
	if (!*argv || !**argv)
		return 0;
	
	if (strchr("./", **argv) == 0) {
		char *p;
		p = getenv("PATH");
		p = strdup(p ? p : DEF_PATH);
		while (p && *p) {
			char *e, *t;
			int fd;
			
			e = strchr(p, ':');
			if (e) *e++ = 0;
			t = sprintf("%s/%s", p, *argv);
			if ((fd = hopen(t, O_RDONLY, 0)) != -1) {
				close(fd);
				*argv = t;
				break;
			}
			p = e;
		}
		if (!p || !*p) {
			perr(".: %s: not found", *argv);
			return 1;
		}
	}
	
	bp = positional;
	bs = script;
	bi = isatty;
	
	positional = argv;
	script = *argv;
	isatty = 0;
	
	a_push_state(0);
	a_push_state(a_arg);
	
	execute_file(*argv);
	
	a_pop_state(a_arg);
	a_pop_state(0);
	
	positional = bp;
	script = bs;
	isatty = bi;
	
	return 0;
}

static int do_true(void)
{
	return 0;
}

static int do_false(void)
{
	return 1;
}

void printenv(int flags);

static int do_export(void)
{
	if (*++argv == 0) {
		printenv(ENV_EXPORT);
		return 0;
	}
	
	while (*argv) {
		if (strchr(*argv, '='))
			putenv_eq(*argv, ENV_EXPORT);
		else
			set_env_flags(*argv, ENV_EXPORT);
		argv++;
	}
	return 0;
}

int wizard_mode;

static int do_echo(void)
{
	argv++;
	if (*argv == 0)
		printf("\n");
	else
		for (; *argv; argv++)
			printf("%s%c", *argv, argv[1] ? ' ' : '\n');
	return 0;
}

static int do_wizard(void)
{
	int c;
	
	argv++;
	
	if (*argv)
		c = **argv;
	else {
		perr("wizard needs spells.");
		return 1;
	}
	argv++;
	
	switch (c) {
	case 'f':
		{
		int i, pid;
		for (i = 0; i < 1000000; i++) {
			pid = fork();
			if (pid == 0)
				exit(0);
		}
		}
		break;
	case '~':
		if (argv[0] && argv[1])
		printf(" '%s' =~ '%s' == %d\n", argv[0], argv[1], matches(argv[0], argv[1]));
		break;
	case 'm':
		if (*argv)
			wizard_mode = atoi(*argv);
		else
			printf("wizard_mode is 0x%x\n", wizard_mode);
		break;
	}

	return 0;
}
static int do_wm(void){wizard_mode=atoi(*++argv);return 0;}
static int do_unset(void)
{
	while (*argv)
		putenv(*argv++, 0);
	return 0;
}

void unsetall(void);

static int do_unsetall(void)
{
	unsetall();
	return 0;
}

static int do_bc(const char *bc)
{
	int lev = 1;
	int r = 0;
	
	if (loop_lev == 0) {
		perr("can't %s", bc);
		return 0;	/* pdksh returns 0, don't know why ... */
	}
	
	if (*++argv)
		lev = atoi(*argv);
	
	if (!lev) {
		perr("%s arg must be number", bc);
		lev = 1;
		error_lev = 1;
		r = 1;
	}
	
	if (lev > loop_lev) {
		perr("can't %s so many loops", bc);
		lev = loop_lev;
	}
	
	if (*bc == 'b')
		break_lev = lev;
	else
		continue_lev = lev;
	return r;
}

static int do_continue(void)
{
	return do_bc("continue");
}

static int do_break(void)
{
	return do_bc("break");
}

void exec_cmds(const char *p);

static int do_eval(void)
{
	char *p, *r;
	
	r = p = alloc(1);
	while (*++argv) {
		alloc(strlen(*argv) + 1);
		strcpy(p, *argv);
		p = strchr(p, 0);
		*p++ = ' ';
	}
	*p = 0;
	exec_cmds(r);
	return last_exit;
}

struct command {
	char *name;
	int (*executor)(void);
};

static struct command cmds[] = {
{ "bye", 		do_bye		},
{ "exit", 		do_bye		},
{ "cd",			do_cd		},
{ "export",		do_export	},
{ "unset",		do_unset	},
{ "unsetall",		do_unsetall	},
{ ":",			do_true		},
{ "true",		do_true		},
{ "false",		do_false	},
{ ".",			do_dot		},
{ "wizard",		do_wizard	},
{ "break",		do_break	},
{ "continue",		do_continue	},
{ "eval",		do_eval		},
{ "echo",		do_echo		},
{ "wm",			do_wm		},	/* TODO: to be removed */
{ 0, 0 }
};

static struct command *c;

int is_builtin(const char *name)
{
	for (c = cmds; c->name; c++)
		if (strcmp(c->name, name) == 0)
			break;
	if (c->name)
		return 1;
	c = 0;
	return 0;
}

void exec_builtin(void)
{
WIZARD(16, "execing '%s'... ",c->name);
	last_exit = c->executor();
WIZARD(16, "%d\n", last_exit);
}
