/*
 * refuse.c
 *
 *		This program is free software; you can redistribute it and/or
 *		modify it under the terms of the BSD style license (see
 *		COPYING file included with this software).
 *
 * Authors:	Kazunori Fujiwara <fujiwara@rcac.tdi.co.jp>
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "rcsid.h"
RCSID("$Id: refuse.c,v 1.6 2000/09/30 22:02:51 baggins Exp $")

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <syslog.h>

#include "tcpd.h"
#include "tcpd_local.h"

void refuse(struct request_info *req)
{
	char s1[TCPD_STRINGLEN];
	char s2[TCPD_STRINGLEN];

	tcpd_satostr(s1, sizeof s1, &req->src);
	tcpd_satostr(s2, sizeof s2, &req->dst);

	syslog(deny_severity, "refused connect from %s%s%s[%s] to %s@%s[%s] %s %s %s",
		req->user, req->user[0] == '\0' ? "": "@",
		req->src_name, s1,
		req->service,
		req->dst_name, s2,
		tcpd_lineno(req),
		req->error < 0 ? "error": "",
		req->src_wrongdns ? " src DNS wrong(fake?)" : 
		(req->dst_wrongdns ? " dst DNS wrong(fake?)" : ""));
	clean_exit(req);
}

void tcpd_refuse2(struct request_info *req)
{
	char s1[TCPD_STRINGLEN];
	char s2[TCPD_STRINGLEN];

	tcpd_satostr(s1, sizeof(s1), &req->src);
	tcpd_satostr(s2, sizeof(s2), &req->dst);

	syslog(deny_severity, "refused connect from %s%s%s[%s] to %s@%s[%s] %s : exec string error: %s",
		req->user, req->user[0] == '\0' ? "": "@",
		req->src_name, s1,
		req->service,
		req->dst_name, s2,
		tcpd_lineno(req),
		req->commands);
	clean_exit(req);
}
