/*
 * tcpd.h	Main header file.
 *
 * 		$Id: tcpd.h,v 1.8 2000/09/28 16:20:41 baggins Exp $
 * 
 * 		This program is free software; you can redistribute it and/or
 * 		modify it under the terms of the BSD style license (see
 * 		COPYING file included with this software).
 *
 * Authors:	Kazunori Fujiwara <fujiwara@rcac.tdi.co.jp>
 *
 */

#ifndef _TCPD_H_
#define _TCPD_H_	1

#include <sys/types.h>
#include <sys/socket.h>

#define	TCPD_HOSTNAMELEN	257
#define	TCPD_STRINGLEN		64
#define	TCPD_STRINGLENL		257

#define TCPD_DEFAULT_RFC1413_TIMEOUT	30

#define STRING_UNKNOWN  "unknown"       /* lookup failed */
#define STRING_PARANOID "paranoid"      /* hostname conflict */

struct request_info {
	int sock; /* socket or file descriptor */
	struct sockaddr_storage src;
	struct sockaddr_storage dst;
	char src_name[TCPD_HOSTNAMELEN];
	char dst_name[TCPD_HOSTNAMELEN];
	char service[TCPD_STRINGLEN];
	char user[TCPD_STRINGLEN];
	char src_wrongdns;
	char dst_wrongdns;
	char error;
	char udp;
	char userresolved;
	int lineno;
	int refuse_wait;
	int rfc1413_timeout;
	char commands_default[TCPD_STRINGLENL];	/* optional commands:default */
	char commands[TCPD_STRINGLENL];	/* optional commands */
};

#define	RQ_END		0 /* */
#define	RQ_FILE		1 /* int: socket fd */
#define	RQ_DAEMON	2 /* char *: service name */
#define	RQ_USER		3 /* set user (for test) */
#define	RQ_SERVER_SIN	4 /* ignore : use RQ_SERVER_ADDR */
#define	RQ_CLIENT_SIN	5 /* ignore : use RQ_CLIENT ADDR */
#define	RQ_SERVER_ADDR	6 /* set server addr (string) */
#define	RQ_CLIENT_ADDR	7 /* set client addr (string) */
#define	RQ_SERVER_NAME	8 /* set server FDQN */
#define	RQ_CLIENT_NAME	9 /* set client FDQN */
#define RQ_SETTABLE	10 /* set another access table */

struct request_info *request_init(struct request_info *, ...);
struct request_info *request_set(struct request_info *, ...);
void fromhost(struct request_info *);
int hosts_access(struct request_info *);
int hosts_ctl(char *daemon, char *client_name, char *client_addr, char *client_user);
void tcpd_satostr(char *str, int len, struct sockaddr_storage *sa);
void refuse(struct request_info *req);
void tcpd_refuse2(struct request_info *req);
void tcpd_allowlog(struct request_info *req);
void clean_exit(struct request_info *req);
void clean_request(struct request_info *req);
char *rfc1413(struct sockaddr_storage *local, struct sockaddr_storage *remote,  char *user, int userlen, int rfc1413_timeout);
int tcpd_exec_option(struct request_info *req);

#define TCPD_ALLOW 1
#define TCPD_DENY  0
#define TCPD_ERROR -1

extern int allow_severity;
extern int deny_severity;

#endif /* tcpd.h */
