/* This is simple demonstration of how to use expat. This program
reads an XML document from standard input and writes a line with the
name of each element to standard output indenting child elements by
one tab stop more than their parent element. */


#include <stdio.h>
#include <unistd.h>
#include "convgen.h"

/* GLOBAL VARIABLES */

XML_Parser parser;		/* the only parser used */
Handlers stack[MAXDEPTH];	/* stack of handler function pointers */
int depth = 0;			/* self explained */
int multiple_files_option = 0;		/* if -m option given, find every refentry in input stream
					   and create proper man files */
int be_quiet_option = 0;
int debug_option = 0;
/* END OF GLOBAL VARIABLES */



void start_tag_handler(void *userdata, const XML_Char *name, const XML_Char **attr)
{
  StartHandler handler;
  if ( ++depth >= MAXDEPTH ) { fprintf(stderr,"Depth too big\n"); exit(-1); }
  find_handlers(name, &stack[depth]);
  handler = stack[depth].starthandler;
  if(handler != NULL) (*handler)(name, attr);
  XML_SetCharacterDataHandler(parser,stack[depth].datahandler);
  
}

void end_tag_handler(void *userdata, const XML_Char *name)
{
  EndHandler handler;
  handler = stack[depth].endhandler;
  if(handler != NULL) (*handler)(name);
  if ( --depth < 0 ) { fprintf(stderr,"Depth < 0 \n"); exit(-1); };
  XML_SetCharacterDataHandler(parser,stack[depth].datahandler);
  
}

int unknown_encoding_handler (void *encodingHandlerData,
			      const XML_Char *name,
			      XML_Encoding *info){
  int i;
  if (strcmp(name,"iso-8859-2") == 0) {
    for(i=0; i<256; i++) info->map[i] = i;
    info->convert = NULL;
    info->data = NULL;
    info->release = NULL;
    return 1;
  }
  return 0;
}


void wait_for_root_element_start(void *userdata, const XML_Char *name, const XML_Char **attr) {
  /* the root element is refentry */
  if (strcmp(name,"refentry") == 0) {
    XML_SetElementHandler(parser, start_tag_handler, end_tag_handler);
    start_tag_handler(userdata, name, attr);
  }
}

int main(int argc, char * const argv[])
{
  XML_Char buf[BUFSIZ];
  
  int done;
  char opt;
  
  while ((opt = getopt(argc, argv, "mqd")) != -1) {
    switch (opt) {
    case 'm': multiple_files_option = 1; break;
    case 'q': be_quiet_option = 1; break;
    case 'd': debug_option = 1; break;
    }      
  }
  parser = XML_ParserCreate(NULL);
 
  XML_SetUnknownEncodingHandler(parser, unknown_encoding_handler, NULL);
  
  //fprintf(stderr,"main\n");

  XML_SetElementHandler(parser, wait_for_root_element_start, NULL);
  //XML_SetElementHandler(parser, start_tag_handler, end_tag_handler);
  
  do {
    size_t len = fread(buf, 1, sizeof(buf), stdin);
    done = len < sizeof(buf);
    if (!XML_Parse(parser, buf, len, done)) {
      fprintf(stderr,
	      "%s at line %d\n",
	      XML_ErrorString(XML_GetErrorCode(parser)),
	      XML_GetCurrentLineNumber(parser));
      return 1;
    }
  } while (!done);
  XML_ParserFree(parser);
  return 0;
}
